/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.switchyard.common.CommonCoreMessages;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.reflect.Access;

public final class FieldAccess<T>
implements Access<T> {
    private Field _field;

    public FieldAccess(Field field) {
        this.setField(field);
    }

    public FieldAccess(Class<?> clazz, String fieldName) {
        Field field;
        fieldName = Strings.trimToNull(fieldName);
        if (fieldName == null) {
            field = null;
        } else {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe1) {
                try {
                    field = clazz.getField(fieldName);
                }
                catch (NoSuchFieldException nsfe2) {
                    field = null;
                }
            }
        }
        this.setField(field);
    }

    private void setField(Field field) {
        this._field = field;
        if (!this._field.isAccessible()) {
            this._field.setAccessible(true);
        }
    }

    @Override
    public String getName() {
        return this._field.getName();
    }

    @Override
    public Class<T> getType() {
        return this._field.getType();
    }

    @Override
    public boolean isReadable() {
        return !Modifier.isStatic(this._field.getModifiers());
    }

    @Override
    public boolean isWriteable() {
        int mod = this._field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    @Override
    public T read(Object target) {
        try {
            return (T)this._field.get(target);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    @Override
    public void write(Object target, T value) {
        try {
            this._field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public String toString() {
        Class<T> clazz = this.getType();
        String type = clazz != null ? clazz.getSimpleName() : null;
        return CommonCoreMessages.MESSAGES.fieldAccessString(this.getName(), type, this.isReadable(), this.isWriteable());
    }
}

