/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.resource;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.switchyard.common.CommonCoreMessages;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;

public final class ResourceType
implements Comparable<ResourceType> {
    private static final Logger LOGGER = Logger.getLogger(ResourceType.class);
    private static final Map<String, ResourceType> TYPES = new ConcurrentHashMap<String, ResourceType>();
    private final String _name;
    private String _description;
    private Set<String> _extensions;
    private Set<ResourceType> _inherited;

    private ResourceType(String name, String description, Set<String> extensions, Set<ResourceType> inherited) {
        this._name = name;
        this._description = description;
        this._extensions = extensions;
        this._inherited = inherited;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public Set<String> getExtensions() {
        return this.getExtensions(true);
    }

    public Set<String> getExtensions(boolean includeInherited) {
        TreeSet<String> exts = new TreeSet<String>();
        exts.addAll(this._extensions);
        if (includeInherited) {
            for (ResourceType type : this._inherited) {
                exts.addAll(type.getExtensions(true));
            }
        }
        return Collections.unmodifiableSet(exts);
    }

    public String toString() {
        return this._name;
    }

    @Override
    public int compareTo(ResourceType type) {
        return type != null ? this._name.compareTo(type._name) : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    public static synchronized void install() {
        ResourceType.install(ResourceType.class);
    }

    public static synchronized void install(Class<?> caller) {
        ResourceType.install(caller != null ? caller.getClassLoader() : null);
    }

    public static synchronized void install(ClassLoader loader) {
        List<Object> urls;
        try {
            urls = Classes.getResources("/org/switchyard/common/io/resource/resourceType.properties", loader);
        }
        catch (Throwable t) {
            LOGGER.fatal((Object)t.getMessage());
            urls = Collections.emptyList();
        }
        PropertiesPuller props_puller = new PropertiesPuller();
        for (URL uRL : urls) {
            try {
                Properties props = (Properties)props_puller.pull(uRL);
                for (Object key : props.keySet()) {
                    String name = (String)key;
                    StringTokenizer st = new StringTokenizer(props.getProperty(name), "|");
                    String description = st.hasMoreTokens() ? Strings.trimToNull(st.nextToken()) : null;
                    Set<String> extensions = st.hasMoreTokens() ? Strings.uniqueSplitTrimToNull(st.nextToken(), ",") : null;
                    ResourceType.install(name, description, extensions, false);
                }
            }
            catch (Throwable t) {
                LOGGER.error((Object)t.getMessage());
            }
        }
        ResourceType.resolveInheritance();
    }

    public static synchronized ResourceType install(String name) {
        return ResourceType.install(name, null, new String[0]);
    }

    public static synchronized ResourceType install(String name, String description, String ... extensions) {
        TreeSet<String> ext_set = null;
        if (extensions != null) {
            for (String ext : extensions) {
                if ((ext = Strings.trimToNull(ext)) == null) continue;
                if (ext_set == null) {
                    ext_set = new TreeSet<String>();
                }
                ext_set.add(ext);
            }
        }
        return ResourceType.install(name, description, ext_set);
    }

    public static synchronized ResourceType install(String name, String description, Set<String> extensions) {
        return ResourceType.install(name, description, extensions, true);
    }

    private static synchronized ResourceType install(String name, String description, Set<String> extensions, boolean resolveInheritance) {
        ResourceType type;
        if ((name = Strings.trimToNull(name)) == null) {
            throw CommonCoreMessages.MESSAGES.nameNull();
        }
        name = name.toUpperCase();
        description = Strings.trimToNull(description);
        TreeSet<String> ext_set = new TreeSet<String>();
        if (extensions != null) {
            for (String ext : extensions) {
                if ((ext = Strings.trimToNull(ext)) == null) continue;
                ResourceType preinstalled = ResourceType.forExtension(ext = ext.toLowerCase());
                if (preinstalled == null) {
                    ext_set.add(ext);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Extension [" + ext + "] already installed by [" + preinstalled._name + "], so will not be included in [" + name + "]. Use extension reference [{" + preinstalled._name + "}] instead."));
            }
        }
        if ((type = TYPES.get(name)) == null) {
            type = new ResourceType(name, description, ext_set, new TreeSet<ResourceType>());
            TYPES.put(name, type);
        } else {
            if (type._description == null && description != null) {
                type._description = description;
            }
            for (String ext : ext_set) {
                if (type._extensions.contains(ext)) continue;
                type._extensions.add(ext);
            }
        }
        if (resolveInheritance) {
            ResourceType.resolveInheritance();
        }
        return type;
    }

    private static synchronized void resolveInheritance() {
        for (ResourceType type : TYPES.values()) {
            TreeSet<String> extensions = new TreeSet<String>();
            for (String ext : type.getExtensions(false)) {
                boolean bounded = false;
                ResourceType inherited = null;
                if (ext.startsWith("{") && ext.endsWith("}")) {
                    bounded = true;
                    String name = ext.substring(1, ext.length() - 1);
                    inherited = ResourceType.valueOf(name);
                }
                if (inherited != null) {
                    type._inherited.add(inherited);
                    continue;
                }
                if (bounded) continue;
                extensions.add(ext);
            }
            type._extensions = extensions;
        }
    }

    public static String[] names() {
        Set<String> names = ResourceType.nameSet();
        return names.toArray(new String[names.size()]);
    }

    public static Set<String> nameSet() {
        return Collections.unmodifiableSet(new TreeSet<String>(TYPES.keySet()));
    }

    public static ResourceType[] values() {
        Set<ResourceType> values = ResourceType.valueSet();
        return values.toArray(new ResourceType[values.size()]);
    }

    public static Set<ResourceType> valueSet() {
        TreeSet<ResourceType> tmpSet = new TreeSet<ResourceType>();
        tmpSet.addAll(TYPES.values());
        return Collections.unmodifiableSet(tmpSet);
    }

    public static ResourceType valueOf(String name) {
        return ResourceType.forName(name);
    }

    public static ResourceType forName(String name) {
        return (name = Strings.trimToNull(name)) != null ? TYPES.get(name.toUpperCase()) : null;
    }

    public static ResourceType forExtension(String extension) {
        ResourceType[] types = ResourceType.forExtension(extension, false);
        return types.length > 0 ? types[0] : null;
    }

    public static ResourceType[] forExtension(String extension, boolean includeInherited) {
        TreeSet<ResourceType> types = new TreeSet<ResourceType>();
        if ((extension = Strings.trimToNull(extension)) != null) {
            extension = extension.toLowerCase();
            for (ResourceType type : TYPES.values()) {
                if (!type.getExtensions(includeInherited).contains(extension)) continue;
                types.add(type);
            }
        }
        return types.toArray(new ResourceType[types.size()]);
    }

    public static ResourceType forLocation(String location) {
        ResourceType[] types = ResourceType.forLocation(location, false);
        return types.length > 0 ? types[0] : null;
    }

    public static ResourceType[] forLocation(String location, boolean includeInherited) {
        int pos;
        if (location != null && (pos = location.lastIndexOf(46)) != -1) {
            String ext = location.substring(pos, location.length());
            return ResourceType.forExtension(ext, includeInherited);
        }
        return null;
    }

    public static void main(String ... args) {
        for (ResourceType type : ResourceType.values()) {
            System.out.printf("%s: %s %s%n", type.getName(), type.getDescription(), type.getExtensions());
        }
    }

    static {
        ResourceType.install();
    }
}

