/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.reflect.Access;

public final class MethodAccess<T>
implements Access<T> {
    private Method _readMethod;
    private Method _writeMethod;
    private String _name = null;
    private Class<T> _type;

    public MethodAccess(Method readMethod, Method writeMethod) {
        this.setMethods(readMethod, writeMethod);
    }

    public MethodAccess(Class<?> clazz, String readMethodName, String writeMethodName) {
        Method writeMethod;
        Method readMethod;
        readMethodName = Strings.trimToNull(readMethodName);
        if (readMethodName == null) {
            readMethod = null;
        } else {
            try {
                readMethod = clazz.getDeclaredMethod(readMethodName, new Class[0]);
            }
            catch (NoSuchMethodException nsfe1) {
                try {
                    readMethod = clazz.getMethod(readMethodName, new Class[0]);
                }
                catch (NoSuchMethodException nsfe2) {
                    readMethod = null;
                }
            }
        }
        writeMethodName = Strings.trimToNull(writeMethodName);
        if (writeMethodName == null) {
            writeMethod = null;
        } else {
            try {
                writeMethod = clazz.getDeclaredMethod(writeMethodName, new Class[0]);
            }
            catch (NoSuchMethodException nsfe1) {
                try {
                    writeMethod = clazz.getMethod(writeMethodName, new Class[0]);
                }
                catch (NoSuchMethodException nsfe2) {
                    writeMethod = null;
                }
            }
        }
        this.setMethods(readMethod, writeMethod);
    }

    private void setMethods(Method readMethod, Method writeMethod) {
        char c;
        String name;
        if (readMethod != null) {
            this._readMethod = readMethod;
            if (!this._readMethod.isAccessible()) {
                this._readMethod.setAccessible(true);
            }
            this._type = this._readMethod.getReturnType();
            name = this._readMethod.getName();
            if (name.startsWith("get") || name.startsWith("is")) {
                name = name.startsWith("get") ? name.substring(3) : name.substring(2);
                c = Character.toLowerCase(name.charAt(0));
                this._name = c + name.substring(1);
            }
        }
        if (writeMethod != null) {
            this._writeMethod = writeMethod;
            if (!this._writeMethod.isAccessible()) {
                this._writeMethod.setAccessible(true);
            }
            if (this._type == null) {
                this._type = this._writeMethod.getParameterTypes()[0];
            }
            if (this._name == null && (name = this._writeMethod.getName()).startsWith("set")) {
                name = name.substring(3);
                c = Character.toLowerCase(name.charAt(0));
                this._name = c + name.substring(1);
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Class<T> getType() {
        return this._type;
    }

    @Override
    public boolean isReadable() {
        return this._readMethod != null;
    }

    @Override
    public boolean isWriteable() {
        return this._writeMethod != null;
    }

    @Override
    public T read(Object target) {
        if (this._readMethod != null) {
            try {
                return (T)this._readMethod.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }
        return null;
    }

    @Override
    public void write(Object target, T value) {
        if (this._writeMethod != null) {
            try {
                this._writeMethod.invoke(target, value);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }
    }

    public String toString() {
        Class<T> clazz = this.getType();
        String type = clazz != null ? clazz.getSimpleName() : null;
        return String.format("MethodAccess(name=%s, type=%s, readable=%b, writeable=%b)", this.getName(), type, this.isReadable(), this.isWriteable());
    }
}

