/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.switchyard.common.CommonCoreLogger;
import org.switchyard.common.CommonCoreMessages;
import org.switchyard.common.io.Buffers;

public final class Files {
    public static final void copy(File source, File target) throws IOException {
        Files.copy(source, target, Buffers.DEFAULT_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File source, File target, int bufferSize) throws IOException {
        File targetParent = target.getParentFile();
        if (targetParent != null && !targetParent.exists() && !targetParent.mkdirs()) {
            CommonCoreLogger.ROOT_LOGGER.problemCreatingDirectory(targetParent);
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));
        byte[] buff = new byte[bufferSize];
        try {
            int read;
            while ((read = bis.read(buff)) != -1) {
                bos.write(buff, 0, read);
            }
        }
        finally {
            bos.flush();
            bos.close();
            bis.close();
        }
    }

    public static final void delete(File source) throws IOException {
        if (source != null && source.exists()) {
            if (source.isDirectory()) {
                for (File f : source.listFiles()) {
                    Files.delete(f);
                }
            }
            if (!source.delete()) {
                throw CommonCoreMessages.MESSAGES.couldNotDeleteFile(source.getName());
            }
        }
    }

    private Files() {
    }
}

