/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.switchyard.common.property.PropertyResolver;

public class CompoundPropertyResolver
implements PropertyResolver {
    private List<PropertyResolver> _resolvers = new ArrayList<PropertyResolver>();

    protected CompoundPropertyResolver(PropertyResolver ... resolvers) {
        if (resolvers != null) {
            for (PropertyResolver resolver : resolvers) {
                this.addResolver(resolver);
            }
        }
    }

    protected CompoundPropertyResolver(Collection<PropertyResolver> resolvers) {
        if (resolvers != null) {
            for (PropertyResolver resolver : resolvers) {
                this.addResolver(resolver);
            }
        }
    }

    private void addResolver(PropertyResolver resolver) {
        if (resolver != null && !this._resolvers.contains(resolver) && resolver != this) {
            if (resolver instanceof CompoundPropertyResolver) {
                for (PropertyResolver pr : ((CompoundPropertyResolver)resolver)._resolvers) {
                    this.addResolver(pr);
                }
            } else {
                this._resolvers.add(resolver);
            }
        }
    }

    @Override
    public Object resolveProperty(String key) {
        Object value;
        block1: {
            PropertyResolver resolver;
            value = null;
            if (key == null) break block1;
            Iterator<PropertyResolver> iterator = this._resolvers.iterator();
            while (iterator.hasNext() && (value = (resolver = iterator.next()).resolveProperty(key)) == null) {
            }
        }
        return value;
    }

    public static PropertyResolver compact(PropertyResolver ... resolvers) {
        CompoundPropertyResolver compound = new CompoundPropertyResolver(resolvers);
        return compound._resolvers.size() == 1 ? compound._resolvers.get(0) : compound;
    }

    public static PropertyResolver compact(Collection<PropertyResolver> resolvers) {
        CompoundPropertyResolver compound = new CompoundPropertyResolver(resolvers);
        return compound._resolvers.size() == 1 ? compound._resolvers.get(0) : compound;
    }
}

