/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.cdi;

import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.deploy.ActivatorLoader;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.cdi.CDIDeployMessages;
import org.switchyard.deploy.internal.Deployment;

@ApplicationScoped
public class SwitchYardCDIDeployer
implements Extension {
    private Deployment _deployment;

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event) {
        InputStream swConfigStream;
        try {
            swConfigStream = Classes.getResourceAsStream((String)"/META-INF/switchyard.xml", this.getClass());
        }
        catch (IOException ioe) {
            swConfigStream = null;
        }
        if (swConfigStream != null) {
            try {
                this._deployment = new Deployment(swConfigStream);
            }
            catch (IOException ioEx) {
                throw CDIDeployMessages.MESSAGES.failedReadingConfig(ioEx);
            }
            finally {
                try {
                    swConfigStream.close();
                }
                catch (IOException ioEx) {
                    ioEx.getMessage();
                }
            }
            ServiceDomain domain = new ServiceDomainManager().createDomain();
            this._deployment.init(domain, ActivatorLoader.createActivators((ServiceDomain)domain));
            this._deployment.start();
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event) {
        if (this._deployment != null) {
            this._deployment.stop();
            this._deployment.destroy();
        }
    }
}

