/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import org.jboss.logging.Cause;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoadException;

@MessageLogger(projectCode="SWITCHYARD")
public interface ExtensionLogger {
    public static final ExtensionLogger ROOT_LOGGER = (ExtensionLogger)Logger.getMessageLogger(ExtensionLogger.class, (String)ExtensionLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40000, value="Unable to destroy web context: %s")
    public void unableToDestroyWebContext(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40001, value="Unable to determine host address from connector.  Using alias definition instead.")
    public void unableToDetermineHostAddress();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40002, value="Unable to instantiate class %s")
    public void unableToInstantiateClass(String var1, @Cause InstantiationException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40003, value="Unable to access constructor for %s")
    public void unableToAccessConstructor(String var1, @Cause IllegalAccessException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40004, value="Unable to load class %s")
    public void unableToLoadClass(String var1, @Cause ClassNotFoundException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40005, value="Unable to load module %s")
    public void unableToLoadModule(String var1, @Cause ModuleLoadException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40006, value="Unable to stop %s")
    public void unableToStop(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40007, value="Cannot read package: %s")
    public void cannotReadPackage(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40008, value="Failed to parse URL: %s")
    public void failedToParseURL(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40009, value="No socket binding definition is found for the default listener. Using host='%s', port='%s'")
    public void noSocketBindingDefinitionFound(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40010, value="The default listener '%s' is not a HTTP listener. Using HTTP protocol anyway.")
    public void defaultListenerIsNotHttpListener(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40011, value="No default listener is found. Using schema='%s', host='%s', port='%s'")
    public void noDefaultListenerDefined(String var1, String var2, String var3);
}

