/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.resteasy;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.Registry;
import org.switchyard.ServiceDomain;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.as7.extension.resteasy.RESTEasyResource;
import org.switchyard.as7.extension.util.ServerUtil;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.resteasy.resource.ResourcePublisher;

public class RESTEasyResourcePublisher
implements ResourcePublisher {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    private static final String LISTENER_CLASS = "org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap";
    private static final String SERVER_TEMP_DIR = System.getProperty("jboss.server.temp.dir");
    private static final String SERVLET_NAME = "RestEasy";
    private static final String SERVLET_CLASS = "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher";

    public synchronized Endpoint publish(ServiceDomain domain, String context, List<Object> instances, Map<String, String> contextParams) throws Exception {
        Host host = ServerUtil.getDefaultHost().getHost();
        StandardContext serverContext = (StandardContext)host.findChild("/" + context);
        if (serverContext == null) {
            serverContext = new StandardContext();
            serverContext.setPath("/" + context);
            File docBase = new File(SERVER_TEMP_DIR, context);
            if (!docBase.exists() && !docBase.mkdirs()) {
                throw ExtensionMessages.MESSAGES.unableToCreateTempDirectory(docBase.getPath());
            }
            serverContext.setDocBase(docBase.getPath());
            serverContext.addLifecycleListener((LifecycleListener)new ContextConfig());
            WebCtxLoader loader = new WebCtxLoader(instances.get(0).getClass().getClassLoader());
            loader.setContainer((Container)host);
            serverContext.setLoader((Loader)loader);
            serverContext.setInstanceManager((InstanceManager)new LocalInstanceManager());
            Wrapper wrapper = serverContext.createWrapper();
            wrapper.setName(SERVLET_NAME);
            wrapper.setServletClass(SERVLET_CLASS);
            wrapper.setLoadOnStartup(1);
            serverContext.addChild((Container)wrapper);
            serverContext.addServletMapping("/*", SERVLET_NAME);
            serverContext.addApplicationListener(LISTENER_CLASS);
            if (contextParams != null) {
                for (Map.Entry<String, String> cp : contextParams.entrySet()) {
                    serverContext.addParameter(cp.getKey(), cp.getValue());
                }
            }
            host.addChild((Container)serverContext);
            serverContext.create();
            serverContext.start();
            LOG.info((Object)("Published RESTEasy context " + serverContext.getPath()));
        }
        while (serverContext.isStarting()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Spent sometime to start context.");
            }
        }
        if (serverContext.isStarted()) {
            Registry registry = (Registry)serverContext.getServletContext().getAttribute(Registry.class.getName());
            ArrayList classes = new ArrayList();
            for (Object instance : instances) {
                registry.addSingletonResource(instance);
                classes.add(instance.getClass());
            }
            RESTEasyResource resource = new RESTEasyResource();
            resource.setClasses(classes);
            resource.setContext(serverContext);
            return resource;
        }
        throw ExtensionMessages.MESSAGES.unableToStartContext(context, new RuntimeException("Context not yet started"));
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

