/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.Activator;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.TransformerRegistryLoader;
import org.switchyard.transform.jaxb.internal.JAXBTransformerFactory;
import org.switchyard.validate.ValidatorRegistryLoader;

public abstract class AbstractDeployment {
    public static final String SWITCHYARD_XML = "/META-INF/switchyard.xml";
    private AbstractDeployment _parentDeployment;
    private ServiceDomain _serviceDomain;
    private TransformerRegistryLoader _transformerRegistryLoader;
    private ValidatorRegistryLoader _validatorRegistryLoader;
    private SwitchYardModel _switchyardConfig;
    private QName _name;
    private boolean _failOnMissingActivator = true;
    private List<Transformer<?, ?>> _autoRegisteredTransformers = new ArrayList();
    private static Logger _log = Logger.getLogger(AbstractDeployment.class);

    protected AbstractDeployment(SwitchYardModel configModel) {
        this._switchyardConfig = configModel;
    }

    public void setParentDeployment(AbstractDeployment parentDeployment) {
        this._parentDeployment = parentDeployment;
    }

    public boolean failOnMissingActivator() {
        return this._failOnMissingActivator;
    }

    public void setFailOnMissingActivator(boolean failOnMissingActivator) {
        this._failOnMissingActivator = failOnMissingActivator;
    }

    public final void init(ServiceDomain appServiceDomain, List<Activator> activators) {
        if (appServiceDomain == null) {
            throw new IllegalArgumentException("null 'appServiceDomain' argument.");
        }
        if (this.getConfig() != null) {
            this._name = this.getConfig().getQName();
            if (this._name == null && this.getConfig().getComposite() != null) {
                this._name = this.getConfig().getComposite().getQName();
            }
        }
        this._serviceDomain = appServiceDomain;
        this._transformerRegistryLoader = new TransformerRegistryLoader(appServiceDomain.getTransformerRegistry());
        this._transformerRegistryLoader.loadOOTBTransforms();
        this._validatorRegistryLoader = new ValidatorRegistryLoader(appServiceDomain.getValidatorRegistry());
        this._validatorRegistryLoader.loadOOTBValidates();
        this.doInit(activators);
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        if (this._parentDeployment == null) {
            return this._serviceDomain;
        }
        return this._parentDeployment.getDomain();
    }

    public TransformerRegistryLoader getTransformerRegistryLoader() {
        return this._transformerRegistryLoader;
    }

    public ValidatorRegistryLoader getValidatorRegistryLoader() {
        return this._validatorRegistryLoader;
    }

    protected abstract void doInit(List<Activator> var1);

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();

    public SwitchYardModel getConfig() {
        return this._switchyardConfig;
    }

    protected void deployAutoRegisteredTransformers(ServiceInterface serviceInterface) throws SwitchYardException {
        TransformerRegistry transformerReg = this.getDomain().getTransformerRegistry();
        if (serviceInterface instanceof JavaService) {
            Class javaInterface = ((JavaService)serviceInterface).getJavaInterface();
            List jaxbTransformers = JAXBTransformerFactory.newTransformers((Class)javaInterface);
            for (Transformer jaxbTransformer : jaxbTransformers) {
                if (transformerReg.hasTransformer(jaxbTransformer.getFrom(), jaxbTransformer.getTo())) continue;
                transformerReg.addTransformer(jaxbTransformer);
                this._autoRegisteredTransformers.add(jaxbTransformer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployAutoRegisteredTransformers() {
        TransformerRegistry transformerReg = this.getDomain().getTransformerRegistry();
        try {
            for (Transformer<?, ?> dynamicallyAddedTransformer : this._autoRegisteredTransformers) {
                transformerReg.removeTransformer(dynamicallyAddedTransformer);
            }
        }
        finally {
            this._autoRegisteredTransformers.clear();
        }
    }
}

