/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.Component;

public final class ActivatorLoader {
    private static Logger _log = Logger.getLogger(ActivatorLoader.class);

    private ActivatorLoader() {
    }

    public static List<Activator> createActivators(ServiceDomain serviceDomain) {
        ArrayList<Activator> activators = new ArrayList<Activator>();
        ServiceLoader<Component> componentLoader = ServiceLoader.load(Component.class);
        for (Component component : componentLoader) {
            Activator activator = component.createActivator(serviceDomain);
            _log.debug((Object)("Registered activator " + activator.getClass()));
            activators.add(activator);
        }
        return activators;
    }

    public static List<Activator> createActivators(ServiceDomain serviceDomain, List<Component> components) {
        ArrayList<Activator> activators = new ArrayList<Activator>();
        for (Component component : components) {
            Activator activator = component.createActivator(serviceDomain);
            _log.debug((Object)("Registered activator " + activator.getClass()));
            activators.add(activator);
        }
        return activators;
    }
}

