/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.BaseDeployLogger;
import org.switchyard.BaseDeployMessages;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceMetadata;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.ExtensionsModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.switchyard.EsbInterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.ThrottlingModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.Binding;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.Implementation;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.deploy.event.ApplicationDeployedEvent;
import org.switchyard.deploy.event.ApplicationUndeployedEvent;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Activation;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceMetadataBuilder;
import org.switchyard.metadata.qos.Throttling;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyFactory;

public class Deployment
extends AbstractDeployment {
    private static Logger _log = Logger.getLogger(Deployment.class);
    private Map<String, Activator> _activators = new HashMap<String, Activator>();
    private List<Activation> _components = new LinkedList<Activation>();
    private List<Activation> _serviceBindings = new LinkedList<Activation>();
    private List<Activation> _referenceBindings = new LinkedList<Activation>();

    public Deployment(InputStream configStream) throws IOException {
        super((SwitchYardModel)new ModelPuller().pull(configStream));
    }

    public Deployment(SwitchYardModel configModel) {
        super(configModel);
    }

    @Override
    protected void doInit(List<Activator> activators) {
        _log.debug((Object)("Initializing deployment " + this.getName()));
        this.registerTransformers();
        this.registerValidators();
        if (activators != null) {
            for (Activator activator : activators) {
                Collection<String> activationTypes = activator.getActivationTypes();
                if (activationTypes == null) continue;
                for (String type : activationTypes) {
                    _log.debug((Object)("Registered activation type " + type + " for activator " + activator.getClass() + " on deployment " + this.getName()));
                    this._activators.put(type, activator);
                }
            }
        }
        this.getDomain().getEventPublisher().publish((EventObject)new ApplicationDeployedEvent(this));
    }

    @Override
    public void start() {
        _log.debug((Object)("Starting deployment " + this.getName()));
        try {
            this.deployReferenceBindings();
            this.deployImplementations();
            this.deployServiceBindings();
        }
        catch (RuntimeException e1) {
            _log.debug((Object)("Undeploying partially deployed artifacts of failed deployment " + this.getConfig().getQName()));
            try {
                this.stop();
            }
            catch (RuntimeException e2) {
                _log.debug((Object)("Failed to properly undeploy a partial/failed deployment " + this.getConfig().getQName()), (Throwable)e2);
            }
            throw e1;
        }
    }

    @Override
    public void stop() {
        _log.debug((Object)("Stopping deployment " + this.getName()));
        this.undeployServiceBindings();
        this.undeployImplementations();
        this.undeployReferenceBindings();
    }

    @Override
    public void destroy() {
        _log.debug((Object)("Destroying deployment " + this.getName()));
        this._serviceBindings.clear();
        this._components.clear();
        this._referenceBindings.clear();
        this.getValidatorRegistryLoader().unregisterValidators();
        this.getTransformerRegistryLoader().unregisterTransformers();
        this.getDomain().getEventPublisher().publish((EventObject)new ApplicationUndeployedEvent(this));
        this.getDomain().destroy();
    }

    @Override
    public Lifecycle getGatwayLifecycle(QName serviceName, String bindingName) {
        for (Activation binding : this._serviceBindings) {
            if (!bindingName.equals(binding.getBindingModel().getName()) || !serviceName.equals(binding.getName())) continue;
            return binding.getHandler();
        }
        for (Activation binding : this._referenceBindings) {
            if (!bindingName.equals(binding.getBindingModel().getName()) || !serviceName.equals(binding.getName())) continue;
            return binding.getHandler();
        }
        return null;
    }

    public Activator findActivator(String type) throws SwitchYardException {
        if (this._activators.containsKey(type)) {
            return this._activators.get(type);
        }
        if (this.failOnMissingActivator()) {
            throw BaseDeployMessages.MESSAGES.activatorNotFoundForType(type);
        }
        return null;
    }

    public List<String> getActivationTypes() {
        HashSet<String> types = new HashSet<String>();
        CompositeModel composite = this.getConfig().getComposite();
        for (CompositeReferenceModel reference : composite.getReferences()) {
            for (BindingModel binding : reference.getBindings()) {
                types.add(binding.getType());
            }
        }
        for (CompositeServiceModel service : composite.getServices()) {
            for (BindingModel binding : service.getBindings()) {
                types.add(binding.getType());
            }
        }
        for (ComponentModel component : composite.getComponents()) {
            if (component.getImplementation() == null) continue;
            types.add(component.getImplementation().getType());
        }
        return new ArrayList<String>(types);
    }

    private Activator findActivator(ComponentModel component) throws SwitchYardException {
        if (component.getImplementation() == null) {
            throw BaseDeployMessages.MESSAGES.componentDefNoImpl(component.getName());
        }
        return this.findActivator(component.getImplementation().getType());
    }

    private void registerTransformers() {
        _log.debug((Object)("Registering configured Transformers for deployment " + this.getName()));
        TransformsModel transforms = this.getConfig().getTransforms();
        this.getTransformerRegistryLoader().registerTransformers(transforms);
    }

    private void registerValidators() {
        _log.debug((Object)("Registering configured Validators for deployment " + this.getName()));
        ValidatesModel validates = this.getConfig().getValidates();
        this.getValidatorRegistryLoader().registerValidators(validates);
    }

    private void deployReferenceBindings() {
        _log.debug((Object)("Deploying reference bindings for deployment " + this.getName()));
        for (CompositeReferenceModel reference : this.getConfig().getComposite().getReferences()) {
            int bindingCount = 0;
            for (BindingModel binding : reference.getBindings()) {
                QName refQName = reference.getQName();
                ++bindingCount;
                if (binding.getName() == null) {
                    _log.debug((Object)("Initializing binding name for binding " + bindingCount + " for reference " + reference.getQName() + " for deployment " + this.getName()));
                    binding.setName("_" + reference.getName() + "_" + binding.getType() + "_" + bindingCount);
                }
                _log.debug((Object)("Deploying binding " + binding.getName() + " for reference " + reference.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                if (activator == null) continue;
                ServiceHandler handler = activator.activateBinding(reference.getQName(), binding);
                Activation activation = new Activation(activator, reference.getQName(), binding, handler);
                ServiceInterface si = this.getCompositeReferenceInterface(reference);
                Binding bindingMetadata = new Binding(binding);
                this.validateServiceRegistration(refQName);
                ServiceMetadata metadata = ServiceMetadataBuilder.create().registrant((Registrant)bindingMetadata).build();
                Service svc = this.getDomain().registerService(refQName, si, (ExchangeHandler)handler, metadata);
                activation.addService(svc);
                this._referenceBindings.add(activation);
                handler.start();
            }
        }
    }

    private ServiceInterface getCompositeReferenceInterface(CompositeReferenceModel compositeRefModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeReferenceInterface(compositeRefModel)) {
            serviceInterface = this.loadServiceInterface(compositeRefModel.getInterface());
        } else {
            List componentRefModels = compositeRefModel.getComponentReferences();
            switch (componentRefModels.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    ComponentReferenceModel componentRefModel = (ComponentReferenceModel)componentRefModels.iterator().next();
                    if (!this.hasComponentReferenceInterface(componentRefModel)) break;
                    serviceInterface = this.loadServiceInterface(componentRefModel.getInterface());
                    break;
                }
                default: {
                    throw new SwitchYardException("A composite reference interface must be defined if promoting more than one component reference.");
                }
            }
        }
        return serviceInterface;
    }

    private ServiceInterface getCompositeServiceInterface(CompositeServiceModel compositeServiceModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeServiceInterface(compositeServiceModel)) {
            serviceInterface = this.loadServiceInterface(compositeServiceModel.getInterface());
        } else if (this.hasComponentServiceInterface(compositeServiceModel.getComponentService())) {
            serviceInterface = this.loadServiceInterface(compositeServiceModel.getComponentService().getInterface());
        }
        return serviceInterface;
    }

    private Throttling getCompositeServiceThrottling(CompositeServiceModel compositeServiceModel) {
        ExtensionsModel extensions = compositeServiceModel.getExtensions();
        if (extensions == null) {
            return null;
        }
        ThrottlingModel throttling = extensions.getThrottling();
        if (throttling == null) {
            return null;
        }
        Long timePeriod = throttling.getTimePeriod();
        Throttling retVal = new Throttling();
        retVal.setMaxRequests(throttling.getMaxRequests());
        if (timePeriod != null) {
            retVal.setTimePeriod(timePeriod.longValue());
        }
        return retVal;
    }

    private boolean hasComponentReferenceInterface(ComponentReferenceModel componentRef) {
        return componentRef != null && componentRef.getInterface() != null;
    }

    private boolean hasCompositeReferenceInterface(CompositeReferenceModel compositeRef) {
        return compositeRef != null && compositeRef.getInterface() != null;
    }

    private boolean hasComponentServiceInterface(ComponentServiceModel componentService) {
        return componentService != null && componentService.getInterface() != null;
    }

    private boolean hasCompositeServiceInterface(CompositeServiceModel compositeService) {
        return compositeService != null && compositeService.getInterface() != null;
    }

    private ServiceInterface getComponentReferenceInterface(ComponentReferenceModel reference) {
        ServiceInterface referenceInterface = null;
        if (reference != null && reference.getInterface() != null) {
            referenceInterface = this.loadServiceInterface(reference.getInterface());
        }
        return referenceInterface;
    }

    private ServiceInterface getComponentServiceInterface(ComponentServiceModel service) {
        ServiceInterface serviceInterface = null;
        if (service != null && service.getInterface() != null) {
            serviceInterface = this.loadServiceInterface(service.getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface loadServiceInterface(InterfaceModel intfModel) {
        Object serviceInterface = null;
        if (intfModel != null) {
            if (this.isJavaInterface(intfModel.getType())) {
                String interfaceClass = intfModel.getInterface();
                Class<?> serviceInterfaceType = this.loadClass(interfaceClass);
                if (serviceInterfaceType == null) {
                    throw BaseDeployMessages.MESSAGES.failedToLoadServiceInterface(interfaceClass);
                }
                serviceInterface = JavaService.fromClass(serviceInterfaceType);
            } else if ("wsdl".equals(intfModel.getType())) {
                try {
                    serviceInterface = WSDLService.fromWSDL((String)intfModel.getInterface());
                }
                catch (WSDLReaderException wsdlre) {
                    throw new SwitchYardException((Throwable)wsdlre);
                }
            } else if ("esb".equals(intfModel.getType())) {
                EsbInterfaceModel esbIntf = (EsbInterfaceModel)intfModel;
                this.validateEsbInterface(esbIntf);
                serviceInterface = esbIntf.getOutputType() == null ? new InOnlyService(new InOnlyOperation("", esbIntf.getInputType())) : new InOutService(new InOutOperation("", esbIntf.getInputType(), esbIntf.getOutputType(), esbIntf.getFaultType()));
            }
        }
        return serviceInterface;
    }

    private void validateEsbInterface(EsbInterfaceModel esbIntf) {
        if (esbIntf.getInputType() == null) {
            throw BaseDeployMessages.MESSAGES.inputTypeRequired(esbIntf.toString());
        }
        if (esbIntf.getFaultType() != null && esbIntf.getOutputType() == null) {
            throw BaseDeployMessages.MESSAGES.faultTypeNeedsOutputType(esbIntf.toString());
        }
    }

    private boolean isJavaInterface(String type) {
        return "java".equals(type);
    }

    private void deployImplementations() {
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            ServiceMetadata metadata;
            Activator activator = this.findActivator(component);
            if (activator == null) continue;
            List<Policy> requiresImpl = null;
            try {
                requiresImpl = this.getPolicyRequirements(component.getImplementation());
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
            Implementation impl = new Implementation(component.getImplementation());
            LinkedList<ServiceReference> references = new LinkedList<ServiceReference>();
            for (ComponentReferenceModel reference : component.getReferences()) {
                QName refName = ComponentNames.qualify(component.getQName(), reference.getQName());
                _log.debug((Object)("Registering reference " + refName + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                List models = reference.getModelChildren();
                for (Model model : models) {
                    if (!BindingModel.class.isAssignableFrom(model.getClass())) continue;
                    throw BaseDeployMessages.MESSAGES.componentReferenceBindingsNotAllowed(model.toString(), reference.toString());
                }
                List<Policy> requires = null;
                try {
                    requires = this.getPolicyRequirements(reference);
                }
                catch (Exception e) {
                    throw BaseDeployMessages.MESSAGES.unableCollectRequirements(reference.toString(), e);
                }
                this.validatePolicy(requires, requiresImpl);
                ServiceInterface refIntf = this.getComponentReferenceInterface(reference);
                metadata = ServiceMetadataBuilder.create().security(this.getDomain().getServiceSecurity(reference.getSecurity())).requiredPolicies(requires).registrant((Registrant)impl).build();
                ServiceReference svcRef = this.getDomain().registerServiceReference(refName, refIntf, null, metadata);
                boolean wired = false;
                block9: for (CompositeReferenceModel compositeReference : this.getConfig().getComposite().getReferences()) {
                    for (ComponentReferenceModel componentReference : compositeReference.getComponentReferences()) {
                        if (componentReference == null || !componentReference.equals(reference) || componentReference.getQName().equals(compositeReference.getQName())) continue;
                        svcRef.wire(compositeReference.getQName());
                        wired = true;
                        break block9;
                    }
                }
                if (!wired) {
                    svcRef.wire(ComponentNames.unqualify(svcRef));
                }
                references.add(svcRef);
            }
            if (component.getServices().size() > 1) {
                throw BaseDeployMessages.MESSAGES.multipleServicesFound(component.getName());
            }
            if (component.getServices().size() == 1) {
                ComponentServiceModel service = (ComponentServiceModel)component.getServices().get(0);
                _log.debug((Object)("Registering service " + service.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                List models = service.getModelChildren();
                for (Model model : models) {
                    if (!BindingModel.class.isAssignableFrom(model.getClass())) continue;
                    throw BaseDeployMessages.MESSAGES.componentServiceBindingsNotAllowed(model.toString(), service.toString());
                }
                List<Policy> requires = null;
                try {
                    requires = this.getPolicyRequirements(service);
                    this.validatePolicy(requires, requiresImpl);
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
                requires.addAll(requiresImpl);
                ServiceHandler handler = activator.activateService(service.getQName(), component);
                Activation activation = new Activation(activator, component.getQName(), null, handler);
                ServiceInterface serviceIntf = this.getComponentServiceInterface(service);
                metadata = ServiceMetadataBuilder.create().security(this.getDomain().getServiceSecurity(service.getSecurity())).requiredPolicies(requires).registrant((Registrant)impl).build();
                Service svc = this.getDomain().registerService(service.getQName(), serviceIntf, (ExchangeHandler)handler, metadata);
                activation.addService(svc);
                activation.addReferences(references);
                for (CompositeServiceModel compositeService : this.getConfig().getComposite().getServices()) {
                    ComponentServiceModel componentService = compositeService.getComponentService();
                    if (componentService == null || !componentService.equals(service) || service.getQName().equals(compositeService.getQName())) continue;
                    this.validateServiceRegistration(compositeService.getQName());
                    Service promotedService = this.getDomain().registerService(compositeService.getQName(), serviceIntf, (ExchangeHandler)handler);
                    activation.addPromotion(promotedService);
                }
                this._components.add(activation);
                handler.start();
                continue;
            }
            _log.debug((Object)("Activating component " + component.getQName()));
            activator.activateService(null, component);
            Activation activation = new Activation(activator, component.getQName(), null, null);
            activation.addReferences(references);
            this._components.add(activation);
        }
    }

    private void deployServiceBindings() {
        _log.debug((Object)("Deploying service bindings for deployment " + this.getName()));
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            ServiceReference reference = this.getDomain().registerServiceReference(service.getQName(), this.getCompositeServiceInterface(service));
            Binding bindingMetadata = new Binding(service.getBindings());
            ServiceMetadataBuilder.update((ServiceMetadata)reference.getServiceMetadata()).throttling(this.getCompositeServiceThrottling(service)).registrant((Registrant)bindingMetadata);
            int bindingCount = 0;
            for (BindingModel binding : service.getBindings()) {
                ++bindingCount;
                if (binding.getName() == null) {
                    _log.debug((Object)("Initializing binding name for binding " + bindingCount + " for service " + service.getQName() + " for deployment " + this.getName()));
                    binding.setName("_" + service.getName() + "_" + binding.getType() + "_" + bindingCount);
                }
                _log.debug((Object)("Deploying binding " + binding.getName() + " for service " + service.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                if (activator == null) continue;
                ServiceHandler handler = activator.activateBinding(service.getQName(), binding);
                Activation activation = new Activation(activator, service.getQName(), binding, handler);
                activation.addReference(reference);
                this._serviceBindings.add(activation);
                handler.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployServiceBindings() {
        _log.debug((Object)("Undeploying service bindings for deployment " + this.getName()));
        try {
            for (Activation activation : this._serviceBindings) {
                try {
                    activation.getHandler().stop();
                }
                catch (Throwable e) {
                    BaseDeployLogger.ROOT_LOGGER.errorStoppingServiceBinding(e);
                }
                try {
                    activation.getActivator().deactivateBinding(activation.getName(), activation.getHandler());
                }
                catch (Throwable e) {
                    BaseDeployLogger.ROOT_LOGGER.errorDeactivatingServiceBinding(e);
                }
                for (ServiceReference reference : activation.getReferences()) {
                    reference.unregister();
                }
            }
        }
        finally {
            this._serviceBindings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployImplementations() {
        _log.debug((Object)("Undeploying services for deployment " + this.getName()));
        try {
            for (Activation activation : this._components) {
                _log.debug((Object)("Deactivating " + activation.getName()));
                ServiceHandler handler = activation.getHandler();
                if (handler != null) {
                    try {
                        handler.stop();
                    }
                    catch (Throwable e) {
                        BaseDeployLogger.ROOT_LOGGER.errorStoppingService(e);
                    }
                }
                for (Service service : activation.getServices()) {
                    try {
                        activation.getActivator().deactivateService(service.getName(), activation.getHandler());
                    }
                    catch (Throwable e) {
                        BaseDeployLogger.ROOT_LOGGER.errorDeactivatingService(e);
                    }
                    service.unregister();
                }
                for (ServiceReference reference : activation.getReferences()) {
                    reference.unregister();
                }
                for (Service service : activation.getPromotions()) {
                    service.unregister();
                }
            }
        }
        finally {
            this._components.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployReferenceBindings() {
        _log.debug((Object)("Undeploying reference bindings for deployment " + this.getName()));
        try {
            for (Activation activation : this._referenceBindings) {
                try {
                    activation.getHandler().stop();
                }
                catch (Throwable e) {
                    BaseDeployLogger.ROOT_LOGGER.errorStoppingReferenceBinding(e);
                }
                try {
                    activation.getActivator().deactivateBinding(activation.getName(), activation.getHandler());
                }
                catch (Throwable e) {
                    BaseDeployLogger.ROOT_LOGGER.errorDeactivatingReferenceBinding(e);
                }
                for (Service service : activation.getServices()) {
                    service.unregister();
                }
            }
        }
        finally {
            this._referenceBindings.clear();
        }
    }

    private Class<?> loadClass(String className) {
        return Classes.forName((String)className, this.getClass());
    }

    private List<Policy> getPolicyRequirements(ComponentServiceModel serviceModel) throws Exception {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : serviceModel.getPolicyRequirements()) {
            requires.add(PolicyFactory.getPolicy((String)policyName));
        }
        return requires;
    }

    private List<Policy> getPolicyRequirements(ComponentImplementationModel implModel) throws Exception {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : implModel.getPolicyRequirements()) {
            requires.add(PolicyFactory.getPolicy((String)policyName));
        }
        return requires;
    }

    private List<Policy> getPolicyRequirements(ComponentReferenceModel referenceModel) throws Exception {
        LinkedList<Policy> requires = new LinkedList<Policy>();
        for (String policyName : referenceModel.getPolicyRequirements()) {
            requires.add(PolicyFactory.getPolicy((String)policyName));
        }
        return requires;
    }

    private void validatePolicy(List<Policy> interaction, List<Policy> implementation) {
        int j;
        Policy required;
        int i;
        for (i = 0; interaction != null && i < interaction.size(); ++i) {
            if (!interaction.get(i).supports(Policy.PolicyType.INTERACTION)) {
                BaseDeployMessages.MESSAGES.policyNotInteraction(interaction.get(i).toString());
            }
            if ((required = interaction.get(i).getPolicyDependency()) != null) {
                if (required.supports(Policy.PolicyType.INTERACTION) && !interaction.contains(required)) {
                    throw BaseDeployMessages.MESSAGES.interactionPolicyShouldBeRequestedWith(interaction.get(i).toString(), required.toString());
                }
                if (required.supports(Policy.PolicyType.IMPLEMENTATION) && !implementation.contains(required)) {
                    throw BaseDeployMessages.MESSAGES.interactionPolicyRequiresImplPolicy(interaction.get(i).toString(), required.toString(), implementation.toString());
                }
            }
            for (j = i + 1; j < interaction.size(); ++j) {
                if (interaction.get(i).isCompatibleWith(interaction.get(j))) continue;
                BaseDeployMessages.MESSAGES.interactionPolicyNotCompatible(interaction.get(i).toString(), interaction.get(j).toString());
            }
        }
        for (i = 0; implementation != null && i < implementation.size(); ++i) {
            if (!implementation.get(i).supports(Policy.PolicyType.IMPLEMENTATION)) {
                BaseDeployMessages.MESSAGES.policyNotImplementationPolicy(implementation.get(i).toString());
            }
            if ((required = implementation.get(i).getPolicyDependency()) != null) {
                if (required.supports(Policy.PolicyType.IMPLEMENTATION) && !implementation.contains(required)) {
                    throw BaseDeployMessages.MESSAGES.implementationPolicyShouldBeRequestedWith(implementation.get(i).toString(), required.toString());
                }
                if (required.supports(Policy.PolicyType.INTERACTION) && !interaction.contains(required)) {
                    throw BaseDeployMessages.MESSAGES.implementationPolicyRequiresInterPolicy(implementation.get(i).toString(), required.toString(), interaction.toString());
                }
            }
            for (j = i + 1; j < implementation.size(); ++j) {
                if (implementation.get(i).isCompatibleWith(implementation.get(j))) continue;
                BaseDeployMessages.MESSAGES.implementationPolicyNotCompatible(implementation.get(i).toString(), implementation.get(j).toString());
            }
            for (j = 0; interaction != null && j < interaction.size(); ++j) {
                if (implementation.get(i).isCompatibleWith(interaction.get(j))) continue;
                throw BaseDeployMessages.MESSAGES.implementationPolicyNotCompatibleWithInteraction(implementation.get(i).toString(), interaction.get(j).toString());
            }
        }
    }

    private void validateServiceRegistration(QName name) {
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            for (ComponentServiceModel service : component.getServices()) {
                if (!service.getQName().equals(name)) continue;
                throw BaseDeployMessages.MESSAGES.serviceRegHidesService(name.toString(), service.toString());
            }
        }
    }
}

