/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.internal.smooks;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.log4j.Logger;
import org.milyn.Smooks;
import org.milyn.container.plugin.SourceFactory;
import org.milyn.javabean.binding.model.Bean;
import org.milyn.javabean.binding.model.ModelSet;
import org.milyn.javabean.binding.xml.XMLBinding;
import org.switchyard.transform.BaseTransformer;

public class XMLBindingTransformer
extends BaseTransformer {
    private static Logger _log = Logger.getLogger(XMLBindingTransformer.class);
    private XMLBinding _xmlBinding;
    private Bean _bean;
    private BindingDirection _direction;

    protected XMLBindingTransformer(QName from, QName to, Smooks smooks, ModelSet beanModel, BindingDirection direction) {
        super(from, to);
        this._xmlBinding = new XMLBinding(smooks);
        this._xmlBinding.setOmitXMLDeclaration(true);
        this._xmlBinding.intiailize();
        this._bean = (Bean)beanModel.getModels().values().iterator().next();
        this._direction = direction;
    }

    public Object transform(Object from) {
        if (from == null) {
            _log.debug((Object)"Null from payload passed to XMLBindingTransformer.  Returning null.");
            return null;
        }
        if (this._direction == BindingDirection.XML2JAVA) {
            Source source = SourceFactory.getInstance().createSource(from);
            try {
                return this._xmlBinding.fromXML(source, this._bean.getBeanClass());
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while transforming from XML to '" + this._bean.getBeanClass().getName() + "'.", e);
            }
        }
        if (!this._bean.getBeanClass().isInstance(from)) {
            throw new RuntimeException("Cannot transform to XML.  Input type is '" + from.getClass().getName() + "' but should be '" + this._bean.getBeanClass().getName() + "'.");
        }
        return this._xmlBinding.toXML(from);
    }

    public static enum BindingDirection {
        XML2JAVA,
        JAVA2XML;

    }
}

