/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.milyn.archive.Archive;
import org.milyn.assertion.AssertArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMerger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private List<String> resourcePaths = new ArrayList<String>();

    public ResourceMerger(String resourcePath) {
        AssertArgument.isNotNull(resourcePath, "resourcePath");
        this.resourcePaths.add(resourcePath);
    }

    public ResourceMerger(List<String> resourcesPaths) {
        AssertArgument.isNotNull(this.resourcePaths, "resourcePaths");
        this.resourcePaths.addAll(resourcesPaths);
    }

    public Archive mergeJars(String jarname, File ... archives) throws IOException {
        AssertArgument.isNotNull(jarname, "jarname");
        AssertArgument.isNotNull(archives, "archives");
        ArrayList<Archive> jars = new ArrayList<Archive>();
        for (File jar : archives) {
            jars.add(new Archive(new JarInputStream(new FileInputStream(jar))));
        }
        return this.mergeJars(jarname, jars);
    }

    public Archive mergeJars(String jarname, List<Archive> archives) throws IOException {
        AssertArgument.isNotNull(jarname, "jarname");
        AssertArgument.isNotNull(archives, "archives");
        Archive all = this.getOrCreateArchive(jarname);
        HashMap<String, List<byte[]>> pathToBytesMap = new HashMap<String, List<byte[]>>();
        for (Archive jar : archives) {
            for (String resourcePath : this.resourcePaths) {
                byte[] content;
                Map<String, byte[]> entries = jar.getEntries();
                if (!entries.containsKey(resourcePath) || (content = entries.get(resourcePath)) == null) continue;
                List<byte[]> list = this.getContentListForResource(pathToBytesMap, resourcePath);
                list.add(content);
                pathToBytesMap.put(resourcePath, list);
            }
            all.merge(jar);
        }
        return this.mergeResources(pathToBytesMap, all);
    }

    private Archive getOrCreateArchive(String jarname) throws FileNotFoundException, IOException {
        File jarfile = new File(jarname);
        if (jarfile.exists()) {
            return new Archive(new ZipInputStream(new FileInputStream(jarfile)));
        }
        return new Archive(jarname);
    }

    private Archive mergeResources(Map<String, List<byte[]>> pathToBytesMap, Archive jar) throws IOException {
        Set<Map.Entry<String, List<byte[]>>> entrySet = pathToBytesMap.entrySet();
        for (Map.Entry<String, List<byte[]>> resourceEntries : entrySet) {
            String resourcePath = resourceEntries.getKey();
            List<byte[]> nodes = resourceEntries.getValue();
            StringWriter stringWriter = new StringWriter();
            for (byte[] content : nodes) {
                this.append(content, stringWriter);
            }
            jar.addEntry(resourcePath, stringWriter.toString());
        }
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(byte[] content, StringWriter to) throws IOException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
            while ((line = in.readLine()) != null) {
                to.write(line);
                to.write(LINE_SEPARATOR);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private List<byte[]> getContentListForResource(Map<String, List<byte[]>> map, String resourcePath) {
        List<byte[]> list = map.get(resourcePath);
        if (list == null) {
            list = new ArrayList<byte[]>();
        }
        return list;
    }
}

