/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.archive.Archive;
import org.milyn.archive.ArchiveClassLoader;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.EDIParser;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.DelimiterType;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.io.StreamUtils;
import org.milyn.resource.URIResourceLocator;
import org.milyn.util.ClassUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIUtils {
    private static Log logger = LogFactory.getLog(EDIUtils.class);
    public static final String EDI_MAPPING_MODEL_ZIP_LIST_FILE = "META-INF/services/org/smooks/edi/mapping-model.lst";
    public static final String EDI_MAPPING_MODEL_INTERCHANGE_PROPERTIES_FILE = "META-INF/services/org/smooks/edi/interchange.properties";
    public static final String EDI_MAPPING_MODEL_URN = "META-INF/services/org/smooks/edi/urn";
    public static final Description MODEL_SET_DEFINITIONS_DESCRIPTION = new Description().setName("__modelset_definitions").setVersion("local");
    public static final String MODEL_SET_DEFINITIONS_DESCRIPTION_LOOKUP_NAME = EDIUtils.toLookupName(MODEL_SET_DEFINITIONS_DESCRIPTION);

    public static String[] split(String value, String delimiter, String escape) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return new String[0];
        }
        if (delimiter == null) {
            delimiter = " ";
        }
        ArrayList<CharSequence> charSequences = new ArrayList<CharSequence>();
        EDIUtils.readSequenceStructure(value, delimiter, escape, charSequences);
        return EDIUtils.putCharacterSequenceIntoResult(charSequences);
    }

    public static void loadMappingModels(String mappingModelFiles, Map<String, EdifactModel> mappingModels, URI baseURI) throws EDIConfigurationException, IOException, SAXException {
        String[] mappingModelFileTokens;
        AssertArgument.isNotNullAndNotEmpty(mappingModelFiles, "mappingModelFiles");
        AssertArgument.isNotNull(mappingModels, "mappingModels");
        AssertArgument.isNotNull(baseURI, "baseURI");
        for (String mappingModelFile : mappingModelFileTokens = mappingModelFiles.split(",")) {
            if ((mappingModelFile = mappingModelFile.trim()).endsWith(".xml")) {
                if (EDIUtils.loadXMLMappingModel(mappingModelFile, mappingModels, baseURI)) {
                    continue;
                }
            } else if (mappingModelFile.endsWith(".zip") || mappingModelFile.endsWith(".jar")) {
                if (EDIUtils.loadZippedMappingModels(mappingModelFile, mappingModels, baseURI)) {
                    continue;
                }
            } else if (mappingModelFile.startsWith("urn:")) {
                String urn = mappingModelFile.substring(4);
                List<String> rootMappingModels = EDIUtils.getMappingModelList(urn);
                EDIUtils.loadMappingModels(mappingModels, baseURI, rootMappingModels);
                continue;
            }
            if (EDIUtils.loadXMLMappingModel(mappingModelFile, mappingModels, baseURI) || EDIUtils.loadZippedMappingModels(mappingModelFile, mappingModels, baseURI)) continue;
            throw new EDIConfigurationException("Failed to process EDI Mapping Model config file '" + mappingModelFile + "'.  Not a valid EDI Mapping Model configuration.");
        }
    }

    private static boolean loadXMLMappingModel(String mappingModelFile, Map<String, EdifactModel> mappingModels, URI baseURI) throws EDIConfigurationException {
        try {
            EdifactModel model = EDIParser.parseMappingModel(mappingModelFile, baseURI);
            mappingModels.put(EDIUtils.toLookupName(model.getEdimap().getDescription()), model);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SAXException e) {
            logger.debug((Object)("Configured mapping model file '" + mappingModelFile + "' is not a valid Mapping Model xml file."));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadZippedMappingModels(String mappingModelFile, Map<String, EdifactModel> mappingModels, URI baseURI) throws IOException, SAXException, EDIConfigurationException {
        Archive archive;
        URIResourceLocator locator = new URIResourceLocator();
        locator.setBaseURI(baseURI);
        InputStream rawZipStream = locator.getResource(mappingModelFile);
        if (rawZipStream != null && (archive = EDIUtils.loadArchive(rawZipStream)) != null) {
            List<String> rootMappingModels = EDIUtils.getMappingModelList(archive);
            if (rootMappingModels.isEmpty()) {
                logger.debug((Object)("Configured mapping model file '" + mappingModelFile + "' is not a valid Mapping Model zip file.  Check that the zip has a valid '" + EDI_MAPPING_MODEL_ZIP_LIST_FILE + "' mapping list file."));
                return false;
            }
            ClassLoader threadCCL = Thread.currentThread().getContextClassLoader();
            try {
                ArchiveClassLoader archiveClassLoader = new ArchiveClassLoader(threadCCL, archive);
                Thread.currentThread().setContextClassLoader(archiveClassLoader);
                EDIUtils.loadMappingModels(mappingModels, baseURI, rootMappingModels);
            }
            finally {
                Thread.currentThread().setContextClassLoader(threadCCL);
            }
            return true;
        }
        return false;
    }

    private static void loadMappingModels(Map<String, EdifactModel> mappingModels, URI baseURI, List<String> rootMappingModels) throws IOException, SAXException, EDIConfigurationException {
        for (String rootMappingModel : rootMappingModels) {
            try {
                EdifactModel mappingModel = EDIParser.parseMappingModel(rootMappingModel, baseURI);
                mappingModel.setAssociateModels(mappingModels.values());
                mappingModels.put(EDIUtils.toLookupName(mappingModel.getDescription()), mappingModel);
            }
            catch (Exception e) {
                throw new EDIConfigurationException("Error parsing EDI Mapping Model '" + rootMappingModel + "'.", e);
            }
        }
    }

    private static List<String> getMappingModelList(Archive archive) throws IOException {
        byte[] zipEntryBytes = archive.getEntries().get(EDI_MAPPING_MODEL_ZIP_LIST_FILE);
        if (zipEntryBytes != null) {
            return EDIUtils.getMappingModelList(new ByteArrayInputStream(zipEntryBytes));
        }
        return Collections.EMPTY_LIST;
    }

    private static List<String> getMappingModelList(String urn) throws IOException, EDIConfigurationException {
        InputStream mappingModelListStream = EDIUtils.getMappingModelConfigStream(urn, EDI_MAPPING_MODEL_ZIP_LIST_FILE);
        if (mappingModelListStream == null) {
            throw new EDIConfigurationException("Failed to locate jar file for EDI Mapping Model URN '" + urn + "'.  Jar must be available on classpath.");
        }
        return EDIUtils.getMappingModelList(mappingModelListStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getInterchangeProperties(String ediMappingModel) throws IOException {
        byte[] bytes;
        Archive archive;
        URIResourceLocator locator;
        InputStream rawZipStream;
        InputStream interchangePropertiesStream = null;
        if (ediMappingModel.startsWith("urn:")) {
            interchangePropertiesStream = EDIUtils.getMappingModelConfigStream(ediMappingModel, EDI_MAPPING_MODEL_INTERCHANGE_PROPERTIES_FILE);
            if (interchangePropertiesStream == null) {
                throw new EDIConfigurationException("Failed to locate jar file for EDI Mapping Model URN '" + ediMappingModel + "'.  Jar must be available on classpath.");
            }
        } else if ((ediMappingModel.endsWith(".jar") || ediMappingModel.endsWith(".zip")) && (rawZipStream = (locator = new URIResourceLocator()).getResource(ediMappingModel)) != null && (archive = EDIUtils.loadArchive(rawZipStream)) != null && (bytes = archive.getEntries().get(EDI_MAPPING_MODEL_INTERCHANGE_PROPERTIES_FILE)) != null) {
            interchangePropertiesStream = new ByteArrayInputStream(bytes);
        }
        if (interchangePropertiesStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(interchangePropertiesStream);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                interchangePropertiesStream.close();
            }
        }
        return null;
    }

    public static String concatAndTruncate(List<String> nodeTokens, DelimiterType outerDelimiterType, Delimiters delimiters) {
        if (nodeTokens.isEmpty()) {
            return "";
        }
        for (int i = nodeTokens.size() - 1; i >= 0 && delimiters.removeableNodeToken(nodeTokens.get(i), outerDelimiterType); --i) {
            nodeTokens.remove(i);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String nodeToken : nodeTokens) {
            stringBuilder.append(nodeToken);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getMappingModelConfigStream(String urn, String fileName) throws IOException, EDIConfigurationException {
        List<URL> urnFiles = ClassUtil.getResources(EDI_MAPPING_MODEL_URN, EDIUtils.class);
        boolean ignoreVersion = false;
        if (urn.startsWith("urn:")) {
            urn = urn.substring(4);
        }
        if (urn.endsWith(":*")) {
            ignoreVersion = true;
            urn = urn.substring(0, urn.lastIndexOf(58));
        }
        for (URL urnFile : urnFiles) {
            InputStream urnStream = urnFile.openStream();
            try {
                String archiveURN = StreamUtils.readStreamAsString(urnStream);
                if (ignoreVersion) {
                    archiveURN = archiveURN.substring(0, archiveURN.lastIndexOf(58));
                }
                if (!archiveURN.equals(urn)) continue;
                String urnFileString = urnFile.toString();
                String modelConfigFile = urnFileString.substring(0, urnFileString.length() - EDI_MAPPING_MODEL_URN.length()) + fileName;
                List<URL> urlList = ClassUtil.getResources(fileName, EDIUtils.class);
                for (URL url : urlList) {
                    if (!url.toString().equals(modelConfigFile)) continue;
                    InputStream inputStream = url.openStream();
                    return inputStream;
                }
            }
            finally {
                urnStream.close();
            }
        }
        throw new EDIConfigurationException("Failed to locate jar file for EDI Mapping Model URN '" + urn + "'.  Jar must be available on classpath.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getMappingModelList(InputStream modelListStream) throws IOException {
        ArrayList<String> rootMappingModels = new ArrayList<String>();
        try {
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(modelListStream, "UTF-8"));
            String line = lineReader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    rootMappingModels.add(line);
                }
                line = lineReader.readLine();
            }
        }
        finally {
            modelListStream.close();
        }
        return rootMappingModels;
    }

    private static Archive loadArchive(InputStream rawStream) {
        try {
            return new Archive(new ZipInputStream(rawStream));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] putCharacterSequenceIntoResult(List<CharSequence> charSequences) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean escapeNextSequence = false;
        boolean delimiterLastSequence = false;
        CharSequence previousSequence = null;
        block9: for (CharSequence sequence : charSequences) {
            delimiterLastSequence = false;
            if (escapeNextSequence && sequence.getType() != CharSequenceTypeEnum.DELIMITER) {
                stringBuilder.append(previousSequence.getValue());
            }
            try {
                switch (sequence.getType()) {
                    case PLAIN: {
                        stringBuilder.append(sequence.getValue());
                        break;
                    }
                    case DELIMITER: {
                        if (escapeNextSequence) {
                            stringBuilder.append(sequence.getValue());
                            break;
                        }
                        result.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        delimiterLastSequence = true;
                        break;
                    }
                    case ESCAPE: {
                        if (escapeNextSequence) {
                            stringBuilder.append(sequence.getValue());
                            break;
                        }
                        escapeNextSequence = true;
                        continue block9;
                    }
                }
                escapeNextSequence = false;
            }
            finally {
                previousSequence = sequence;
            }
        }
        if (stringBuilder.length() > 0 || delimiterLastSequence) {
            result.add(stringBuilder.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private static void readSequenceStructure(String value, String delimiter, String escape, List<CharSequence> result) {
        StringBuilder stringBuilder = new StringBuilder();
        int escapeLength = escape == null ? 0 : escape.length();
        int delimiterLength = delimiter == null ? 0 : delimiter.length();
        for (int j = 0; j < value.length(); ++j) {
            char theChar = value.charAt(j);
            stringBuilder.append(theChar);
            int curTokenLength = stringBuilder.length();
            if (EDIUtils.builderEndsWith(stringBuilder, delimiter)) {
                stringBuilder.setLength(curTokenLength - delimiterLength);
                if (stringBuilder.length() > 0) {
                    result.add(new CharSequence(stringBuilder.toString(), CharSequenceTypeEnum.PLAIN));
                    stringBuilder.setLength(0);
                }
                result.add(new CharSequence(delimiter, CharSequenceTypeEnum.DELIMITER));
                continue;
            }
            if (!EDIUtils.builderEndsWith(stringBuilder, escape)) continue;
            stringBuilder.setLength(curTokenLength - escapeLength);
            if (stringBuilder.length() > 0) {
                result.add(new CharSequence(stringBuilder.toString(), CharSequenceTypeEnum.PLAIN));
                stringBuilder.setLength(0);
            }
            result.add(new CharSequence(escape, CharSequenceTypeEnum.ESCAPE));
        }
        if (stringBuilder.length() > 0) {
            result.add(new CharSequence(stringBuilder.toString(), CharSequenceTypeEnum.PLAIN));
        }
    }

    private static boolean builderEndsWith(StringBuilder stringBuilder, String string) {
        int stringLen;
        if (string == null) {
            return false;
        }
        int builderLen = stringBuilder.length();
        if (builderLen < (stringLen = string.length())) {
            return false;
        }
        int stringIndx = 0;
        for (int i = builderLen - stringLen; i < builderLen; ++i) {
            if (stringBuilder.charAt(i) != string.charAt(stringIndx)) {
                return false;
            }
            ++stringIndx;
        }
        return true;
    }

    public static String toLookupName(Description description) {
        return description.getName() + ":" + description.getVersion();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CharSequenceTypeEnum {
        PLAIN,
        ESCAPE,
        DELIMITER;

    }

    private static class CharSequence {
        String value;
        CharSequenceTypeEnum type;

        public CharSequence(String value, CharSequenceTypeEnum type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public CharSequenceTypeEnum getType() {
            return this.type;
        }
    }
}

