/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform;

import java.lang.reflect.ParameterizedType;
import javax.xml.namespace.QName;
import org.switchyard.transform.Transformer;

public abstract class BaseTransformer<F, T>
implements Transformer<F, T> {
    private QName _from;
    private QName _to;

    public BaseTransformer() {
    }

    public BaseTransformer(QName from, QName to) {
        this._from = from;
        this._to = to;
    }

    @Override
    public QName getFrom() {
        return this._from;
    }

    @Override
    public Class<F> getFromType() {
        return this.getType(Types.F);
    }

    @Override
    public QName getTo() {
        return this._to;
    }

    @Override
    public Class<T> getToType() {
        return this.getType(Types.T);
    }

    @Override
    public abstract T transform(F var1);

    private Class<?> getType(Types type) {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)pt.getActualTypeArguments()[type.ordinal()];
    }

    private static enum Types {
        F,
        T;

    }
}

