/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelResource;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Activation;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.config.model.TransformerFactory;

public class Deployment
extends AbstractDeployment {
    private static final String BEAN_ACTIVATOR_CLASS = "org.switchyard.component.bean.deploy.BeanComponentActivator";
    private static final String SOAP_ACTIVATOR_CLASS = "org.switchyard.component.soap.deploy.SOAPActivator";
    private static final String JAVA_INTERFACE = "java";
    private static Logger _log = Logger.getLogger(Deployment.class);
    private SwitchYardModel _switchyardConfig;
    private Map<String, Activator> _componentActivators = new HashMap<String, Activator>();
    private Map<String, Activator> _gatewayActivators = new HashMap<String, Activator>();
    private List<Transformer> _transformers = new LinkedList<Transformer>();
    private List<Activation> _services = new LinkedList<Activation>();
    private List<Activation> _serviceBindings = new LinkedList<Activation>();
    private List<Activation> _references = new LinkedList<Activation>();
    private List<Activation> _referenceBindings = new LinkedList<Activation>();

    public Deployment(InputStream configStream) {
        try {
            this._switchyardConfig = (SwitchYardModel)new ModelResource().pull(configStream);
        }
        catch (IOException ioEx) {
            throw new RuntimeException("Failed to read switchyard config.", ioEx);
        }
    }

    public Deployment(SwitchYardModel configModel) {
        this._switchyardConfig = configModel;
    }

    @Override
    public void init() {
        super.init();
        _log.debug((Object)("Initializing deployment for application " + this._switchyardConfig.getName()));
        this.registerTransformers();
        this.createActivators();
    }

    public void start() {
        _log.debug((Object)("Starting deployment for application " + this._switchyardConfig.getName()));
        try {
            this.deployReferenceBindings();
            this.deployServices();
            this.deployReferences();
            this.deployServiceBindings();
        }
        catch (RuntimeException e1) {
            _log.debug((Object)("Undeploying partially deployed artifacts of failed deployment for application " + this._switchyardConfig.getName()));
            try {
                this.stop();
            }
            catch (RuntimeException e2) {
                _log.debug((Object)("Failed to properly undeploy a partial/failed deployment for application " + this._switchyardConfig.getName()), (Throwable)e2);
            }
            throw e1;
        }
    }

    public void stop() {
        _log.debug((Object)("Stopping deployment for application " + this._switchyardConfig.getName()));
        this.undeployServiceBindings();
        this.undeployServices();
        this.undeployReferences();
        this.undeployReferenceBindings();
    }

    @Override
    public void destroy() {
        _log.debug((Object)("Destroying deployment for application " + this._switchyardConfig.getName()));
        this.destroyDomain();
        this._services.clear();
        this._serviceBindings.clear();
        this._references.clear();
        this._referenceBindings.clear();
        this.unregisterTransformers();
    }

    private void createActivators() {
        this.createComponentActivator("bean", BEAN_ACTIVATOR_CLASS);
        this.createGatewayActivator("soap", SOAP_ACTIVATOR_CLASS);
    }

    private void createGatewayActivator(String type, String runtimeClass) {
        try {
            this._gatewayActivators.put(type, (Activator)this.loadClass(runtimeClass).newInstance());
        }
        catch (Exception ex) {
            _log.debug((Object)("Failed to load Gateway Activator class '" + runtimeClass + "' for component type '" + type + "'."));
        }
    }

    private void createComponentActivator(String type, String runtimeClass) {
        try {
            this._componentActivators.put(type, (Activator)this.loadClass(runtimeClass).newInstance());
        }
        catch (Exception ex) {
            _log.debug((Object)("Failed to load Component Activator class '" + runtimeClass + "' for component type '" + type + "'."));
        }
    }

    private void registerTransformers() {
        _log.debug((Object)"Registering configured Transformers ...");
        TransformerRegistry transformerRegistry = this.getDomain().getTransformerRegistry();
        TransformsModel transforms = this._switchyardConfig.getTransforms();
        if (transforms == null) {
            return;
        }
        try {
            for (TransformModel transformModel : transforms.getTransforms()) {
                Transformer transformer = TransformerFactory.newTransformer((TransformModel)transformModel);
                Transformer registeredTransformer = transformerRegistry.getTransformer(transformer.getFrom(), transformer.getTo());
                if (registeredTransformer != null) {
                    throw new RuntimeException("Failed to register Transformer '" + this.toDescription(transformer) + "'.  A Transformer for these types is already registered: '" + this.toDescription(registeredTransformer) + "'.");
                }
                _log.debug((Object)("Adding transformer => \nFrom: " + transformer.getFrom() + "To:" + transformer.getTo()));
                transformerRegistry.addTransformer(transformer);
                this._transformers.add(transformer);
            }
        }
        catch (RuntimeException e) {
            this.unregisterTransformers();
            throw e;
        }
    }

    private void unregisterTransformers() {
        for (Transformer transformer : this._transformers) {
            this.getDomain().getTransformerRegistry().removeTransformer(transformer);
        }
    }

    private void deployReferenceBindings() {
        _log.debug((Object)"Deploying reference bindings ...");
    }

    private void deployServices() {
        _log.debug((Object)"Deploying services ...");
        for (ComponentModel component : this._switchyardConfig.getComposite().getComponents()) {
            Activator activator = this.getActivator(component);
            for (ComponentServiceModel service : component.getServices()) {
                _log.debug((Object)("Registering service " + service.getName() + " for component " + component.getImplementation().getType()));
                ExchangeHandler handler = activator.init(service.getQName(), (Model)service);
                ServiceReference serviceRef = null;
                if (service.getInterface().getType().equals(JAVA_INTERFACE)) {
                    JavaService si = JavaService.fromClass(this.loadClass(service.getInterface().getInterface()));
                    serviceRef = this.getDomain().registerService(service.getQName(), handler, (ServiceInterface)si);
                } else {
                    serviceRef = this.getDomain().registerService(service.getQName(), handler);
                }
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._services.add(activation);
            }
        }
    }

    private void deployReferences() {
        _log.debug((Object)"Deploying references ...");
        for (ComponentModel component : this._switchyardConfig.getComposite().getComponents()) {
            Activator activator = this.getActivator(component);
            for (ComponentReferenceModel reference : component.getReferences()) {
                _log.debug((Object)("Registering reference " + reference.getName() + " for component " + component.getImplementation().getType()));
                ServiceReference service = this.getDomain().getService(reference.getQName());
                activator.init(reference.getQName(), (Model)reference);
                Activation activation = new Activation(service, activator);
                activation.start();
                this._references.add(activation);
            }
        }
    }

    private void deployServiceBindings() {
        _log.debug((Object)"Deploying service bindings ...");
        for (CompositeServiceModel service : this._switchyardConfig.getComposite().getServices()) {
            for (BindingModel binding : service.getBindings()) {
                _log.debug((Object)("Deploying binding " + binding.getType() + " for service " + service.getName()));
                Activator activator = this._gatewayActivators.get(binding.getType());
                ServiceReference serviceRef = this.getDomain().getService(service.getQName());
                activator.init(serviceRef.getName(), (Model)service);
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._serviceBindings.add(activation);
            }
        }
    }

    private void undeployServiceBindings() {
        _log.debug((Object)"Undeploying reference bindings ...");
        for (Activation activation : this._serviceBindings) {
            activation.stop();
            activation.destroy();
        }
    }

    private void undeployServices() {
        _log.debug((Object)"Undeploying services ...");
        for (Activation activation : this._services) {
            activation.stop();
            activation.destroy();
        }
    }

    private void undeployReferences() {
        _log.debug((Object)"Undeploying references ...");
        for (Activation activation : this._references) {
            activation.stop();
            activation.destroy();
        }
    }

    private void undeployReferenceBindings() {
        _log.debug((Object)"Undeploying reference bindings ...");
        for (Activation activation : this._referenceBindings) {
            activation.stop();
            activation.destroy();
        }
    }

    private void destroyDomain() {
    }

    private Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new RuntimeException(cnfEx);
        }
    }

    private String toDescription(Transformer<?, ?> transformer) {
        return transformer.getClass().getName() + "(" + transformer.getFrom() + ", " + transformer.getTo() + ")";
    }

    private Activator getActivator(ComponentModel component) {
        String type = component.getImplementation().getType();
        Activator activator = this._componentActivators.get(type);
        if (activator == null) {
            throw new RuntimeException("Unknown configuration component type '" + type + "'.  No Activator implementation registered for this type.");
        }
        return activator;
    }
}

