/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Marshaller;
import org.switchyard.config.model.Model;
import org.switchyard.config.util.Classes;
import org.switchyard.config.util.PropertiesResource;
import org.switchyard.config.util.StringResource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public final class Descriptor {
    public static final String DEFAULT_PROPERTIES = "/org/switchyard/config/model/descriptor.properties";
    public static final String NAMESPACE = "namespace";
    public static final String SCHEMA = "schema";
    public static final String LOCATION = "location";
    public static final String MARSHALLER = "marshaller";
    private Map<String, String> _all_properties_map = new TreeMap<String, String>();
    private Map<String, Map<String, String>> _prefix_config_map = new HashMap<String, Map<String, String>>();
    private Map<String, String> _namespace_prefix_map = new HashMap<String, String>();
    private Map<Set<String>, Schema> _namespaces_schema_map = new HashMap<Set<String>, Schema>();
    private Map<String, Marshaller> _namespace_marshaller_map = new HashMap<String, Marshaller>();

    public Descriptor() {
        String dp = DEFAULT_PROPERTIES.substring(1);
        Properties props = new Properties();
        PropertiesResource props_res = new PropertiesResource();
        try {
            List<URL> urls = Classes.getResources(dp, Descriptor.class);
            for (URL url : urls) {
                Properties url_props = (Properties)props_res.pull(url);
                Enumeration<?> pn_enum = url_props.propertyNames();
                while (pn_enum.hasMoreElements()) {
                    String pn = (String)pn_enum.nextElement();
                    props.setProperty(pn, url_props.getProperty(pn));
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.setProperties(props);
    }

    public Descriptor(Properties props) {
        this.setProperties(props);
    }

    private void setProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop_name = (String)e.nextElement();
            String prop_value = props.getProperty(prop_name);
            if (prop_value == null) continue;
            this._all_properties_map.put(prop_name, prop_value);
            StringTokenizer tokenizer = new StringTokenizer(prop_name, ".");
            String prop_prefix = tokenizer.nextToken().trim();
            String prop_suffix = tokenizer.nextToken().trim();
            Map<String, String> config = this._prefix_config_map.get(prop_prefix);
            if (config == null) {
                config = new HashMap<String, String>();
                this._prefix_config_map.put(prop_prefix, config);
            }
            config.put(prop_suffix, prop_value);
            if (!NAMESPACE.equals(prop_suffix)) continue;
            this._namespace_prefix_map.put(prop_value, prop_prefix);
        }
    }

    public String getProperty(String property, String namespace) {
        Map<String, String> config;
        String prop_prefix = this._namespace_prefix_map.get(namespace);
        if (prop_prefix != null && (config = this._prefix_config_map.get(prop_prefix)) != null) {
            return config.get(property);
        }
        return null;
    }

    public synchronized Schema getSchema(Set<String> namespaces) {
        Schema schema = this._namespaces_schema_map.get(namespaces);
        if (schema == null) {
            ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
            try {
                for (String namespace : namespaces) {
                    URL resource;
                    String schemaLocation = this.getSchemaLocation(namespace);
                    if (schemaLocation == null || (resource = Classes.getResource(schemaLocation)) == null) continue;
                    String xsd = (String)new StringResource().pull(resource);
                    sourceList.add(new StreamSource(new StringReader(xsd)));
                }
                if (sourceList.size() > 0) {
                    Source[] sources = sourceList.toArray(new Source[sourceList.size()]);
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver(new DescriptorLSResourceResolver(this));
                    schema = factory.newSchema(sources);
                    this._namespaces_schema_map.put(namespaces, schema);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return schema;
    }

    public Schema getSchema(Configuration config) {
        if (config != null) {
            return this.getSchema(config.getNamespaces());
        }
        return null;
    }

    public static Schema getSchema(Model model) {
        Descriptor desc;
        if (model != null && (desc = model.getModelDescriptor()) != null) {
            return desc.getSchema(model.getModelConfiguration());
        }
        return null;
    }

    public String getLocation(String namespace) {
        return this.getProperty(LOCATION, namespace);
    }

    public String getSchemaLocation(String namespace) {
        return this.getSchemaLocation(namespace, this.getProperty(SCHEMA, namespace));
    }

    private String getSchemaLocation(String namespace, String schema) {
        String location;
        if (namespace != null && schema != null && (location = this.getLocation(namespace)) != null) {
            String schemaLocation = location + "/" + schema;
            schemaLocation = schemaLocation.replaceAll("\\\\", "/").replaceAll("//", "/");
            return schemaLocation;
        }
        return null;
    }

    public synchronized Marshaller getMarshaller(String namespace) {
        String name;
        Marshaller marshaller = this._namespace_marshaller_map.get(namespace);
        if (marshaller == null && (name = this.getProperty(MARSHALLER, namespace)) != null) {
            try {
                Class<?> clazz = Classes.forName(name, Descriptor.class);
                Constructor<?> cnstr = clazz.getConstructor(Descriptor.class);
                marshaller = (Marshaller)cnstr.newInstance(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return marshaller;
    }

    public Marshaller getMarshaller(Configuration config) {
        String namespace;
        QName qname;
        if (config != null && (qname = config.getQName()) != null && (namespace = qname.getNamespaceURI()) != null) {
            return this.getMarshaller(namespace);
        }
        return null;
    }

    public static Marshaller getMarshaller(Model model) {
        Descriptor desc;
        if (model != null && (desc = model.getModelDescriptor()) != null) {
            return desc.getMarshaller(model.getModelConfiguration());
        }
        return null;
    }

    public String toString() {
        return this._all_properties_map.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._all_properties_map == null ? 0 : ((Object)this._all_properties_map).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Descriptor other = (Descriptor)obj;
        return !(this._all_properties_map == null ? other._all_properties_map != null : !((Object)this._all_properties_map).equals(other._all_properties_map));
    }

    private static final class DescriptorLSInput
    implements LSInput {
        private Reader _characterStream;
        private InputStream _byteStream;
        private String _stringData;
        private String _publicId;
        private String _systemId;
        private String _baseURI;
        private String _encoding;
        private boolean _certifiedText;

        private DescriptorLSInput(String xsd, String publicId, String systemId, String baseURI) {
            this.setCharacterStream(new StringReader(xsd));
            this.setByteStream(new ByteArrayInputStream(xsd.getBytes()));
            this.setStringData(xsd);
            this.setPublicId(publicId);
            this.setSystemId(systemId);
            this.setBaseURI(baseURI);
            this.setEncoding("UTF-8");
            this.setCertifiedText(false);
        }

        @Override
        public Reader getCharacterStream() {
            return this._characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this._characterStream = characterStream;
        }

        @Override
        public InputStream getByteStream() {
            return this._byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this._byteStream = byteStream;
        }

        @Override
        public String getStringData() {
            return this._stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this._stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return this._systemId;
        }

        @Override
        public String getPublicId() {
            return this._publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this._publicId = publicId;
        }

        @Override
        public void setSystemId(String systemId) {
            this._systemId = systemId;
        }

        @Override
        public String getBaseURI() {
            return this._baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this._baseURI = baseURI;
        }

        @Override
        public String getEncoding() {
            return this._encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        @Override
        public boolean getCertifiedText() {
            return this._certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this._certifiedText = certifiedText;
        }
    }

    private static final class DescriptorLSResourceResolver
    implements LSResourceResolver {
        private Descriptor _descriptor;

        private DescriptorLSResourceResolver(Descriptor descriptor) {
            this._descriptor = descriptor;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            String schemaLocation = this._descriptor.getSchemaLocation(namespaceURI, systemId);
            if (schemaLocation != null) {
                try {
                    String xsd = (String)new StringResource().pull(schemaLocation);
                    if (xsd != null) {
                        return new DescriptorLSInput(xsd, publicId, systemId, baseURI);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            return null;
        }
    }
}

