/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.switchyard.config.util.Classes;

public abstract class Resource<R> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(String resource) throws IOException {
        InputStream is = Classes.getResourceAsStream(resource, this.getClass());
        if (is != null) {
            try {
                R r = this.pull(is);
                return r;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    public R pull(URI uri) throws IOException {
        return this.pull(uri.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            R r = this.pull(is);
            return r;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            R r = this.pull(is);
            return r;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public abstract R pull(InputStream var1) throws IOException;
}

