/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.util.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.switchyard.config.util.classpath.Filter;

public class ClasspathScanner {
    private static Logger _logger = Logger.getLogger(ClasspathScanner.class);
    private Filter _filter;

    public ClasspathScanner(Filter filter) {
        this._filter = filter;
    }

    public void scan(URL url) throws IOException {
        File file;
        String urlPath = url.getFile();
        if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if (urlPath.indexOf(33) > 0) {
            urlPath = urlPath.substring(0, urlPath.indexOf(33));
        }
        if ((file = new File(urlPath)).exists()) {
            if (file.isDirectory()) {
                this.handleDirectory(file, null);
            } else {
                this.handleArchive(file);
            }
        } else {
            _logger.warn((Object)("Unknown Classpath URL File '" + file.getAbsolutePath() + "'."));
        }
    }

    private void handleArchive(File file) throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Scanning archive: " + file.getAbsolutePath()));
        }
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements() && this._filter.continueScanning()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            this._filter.filter(name);
        }
    }

    private void handleDirectory(File file, String path) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Scanning directory: " + file.getAbsolutePath()));
        }
        for (File child : file.listFiles()) {
            String newPath;
            if (!this._filter.continueScanning()) break;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this._filter.filter(newPath);
        }
    }
}

