/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.bpm;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.component.bpm.config.model.v1.V1BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.v1.V1TaskHandlerModel;
import org.switchyard.component.bpm.task.SwitchYardServiceTaskHandler;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentServiceInterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.forge.bpm.BPMFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.plugin.TemplateResource;

@Alias(value="bpm-service")
@RequiresProject
@RequiresFacet(value={BPMFacet.class, ResourceFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands related to BPM services in SwitchYard.")
public class BPMServicePlugin
implements Plugin {
    private static final String PROCESS_TEMPLATE = "ProcessTemplate.bpmn";
    private static final String PROCESS_EXTENSION = ".bpmn";
    private static final String PROCESS_DIR = "META-INF";
    private static final String VAR_PROCESS_ID = "${process.id}";
    private static final String SWITCHAYRD_TASK_HANDLER = "SwitchYard Service";
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="create", help="Created a new service backed by a BPM process.")
    public void newProcess(@Option(required=true, name="serviceName", description="The service name") String argServiceName, @Option(required=false, name="interfaceClass", description="The Java service interface") String argInterfaceClass, @Option(required=false, name="processDefinition", description="The business process definition") String argProcessFilePath, @Option(required=false, name="processId", description="The business process id") String argProcessId, @Option(required=false, name="agent", description="Whether you want to use an agent to watch resources for changes (true|false)", defaultValue="false") Boolean argAgent, PipeOut out) throws IOException {
        String processDefinitionPath;
        String processId;
        JavaSourceFacet java = (JavaSourceFacet)this._shell.getCurrentProject().getFacet(JavaSourceFacet.class);
        String pkgName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getTopLevelPackage();
        String interfaceClass = argInterfaceClass;
        if (interfaceClass == null) {
            if (pkgName == null) {
                pkgName = this._shell.promptCommon("Java package for service interface:", PromptType.JAVA_PACKAGE);
            }
            JavaInterface processInterface = (JavaInterface)((JavaInterface)((JavaInterface)((JavaInterface)JavaParser.create(JavaInterface.class)).setPackage(pkgName)).setName(argServiceName)).setPublic();
            processInterface.addMethod("void process(String content);");
            java.saveJavaSource((JavaSource)processInterface);
            interfaceClass = processInterface.getQualifiedName();
            out.println("Created service interface [" + interfaceClass + "]");
        }
        if ((processId = argProcessId) == null) {
            processId = argServiceName;
        }
        if ((processDefinitionPath = argProcessFilePath) == null) {
            processDefinitionPath = PROCESS_DIR + File.separator + argServiceName + PROCESS_EXTENSION;
            TemplateResource template = new TemplateResource(PROCESS_TEMPLATE).serviceName(argServiceName).replaceToken(VAR_PROCESS_ID, processId).packageName(pkgName);
            template.writeResource(((ResourceFacet)this._project.getFacet(ResourceFacet.class)).getResource(processDefinitionPath));
            out.println("Created process definition [" + processDefinitionPath + "]");
        }
        boolean agent = argAgent != null ? argAgent : false;
        this.createImplementationConfig(argServiceName, interfaceClass, processId, processDefinitionPath, agent);
        out.println("Process service " + argServiceName + " has been created.");
    }

    private void createImplementationConfig(String serviceName, String interfaceName, String processId, String processDefinition, boolean agent) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        V1ComponentModel component = new V1ComponentModel();
        component.setName(serviceName);
        V1ComponentServiceModel service = new V1ComponentServiceModel();
        service.setName(serviceName);
        V1JavaComponentServiceInterfaceModel csi = new V1JavaComponentServiceInterfaceModel();
        csi.setInterface(interfaceName);
        service.setInterface((ComponentServiceInterfaceModel)csi);
        component.addService((ComponentServiceModel)service);
        V1BPMComponentImplementationModel bpm = new V1BPMComponentImplementationModel();
        bpm.setProcessDefinition((Resource)new SimpleResource(processDefinition));
        bpm.setProcessId(processId);
        if (agent) {
            bpm.setAgent(true);
        }
        V1TaskHandlerModel switchyardHandler = new V1TaskHandlerModel();
        switchyardHandler.setName(SWITCHAYRD_TASK_HANDLER);
        switchyardHandler.setClazz(SwitchYardServiceTaskHandler.class);
        bpm.addTaskHandler(switchyardHandler);
        component.setImplementation((ComponentImplementationModel)bpm);
        SwitchYardModel syConfig = switchYard.getSwitchYardConfig();
        syConfig.getComposite().addComponent((ComponentModel)component);
        switchYard.saveConfig();
    }
}

