/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.bpm.task.BaseTaskHandler;
import org.switchyard.component.bpm.task.Task;
import org.switchyard.component.bpm.task.TaskManager;
import org.switchyard.exception.DeliveryException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;

public class SwitchYardServiceTaskHandler
extends BaseTaskHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceTaskHandler.class);
    public static final String SWITCHYARD_SERVICE = "SwitchYard Service";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String SERVICE_OPERATION_NAME = "ServiceOperationName";

    public SwitchYardServiceTaskHandler() {
        super(SWITCHYARD_SERVICE);
    }

    public SwitchYardServiceTaskHandler(String name) {
        super(name);
    }

    @Override
    public void executeTask(Task task, TaskManager taskManager) {
        String problem = null;
        Map<String, Object> taskParameters = task.getParameters();
        Map<String, Object> taskResults = null;
        QName serviceName = this.getServiceName(taskParameters);
        if (serviceName != null) {
            ServiceReference serviceRef = this.getServiceDomain().getService(serviceName);
            if (serviceRef != null) {
                Exchange exchangeIn;
                ExchangeContract exchangeContract = this.getExchangeContract(serviceRef, taskParameters);
                ExchangePattern exchangePattern = exchangeContract.getServiceOperation().getExchangePattern();
                SynchronousInOutHandler inOutHandler = null;
                if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    inOutHandler = new SynchronousInOutHandler();
                    exchangeIn = serviceRef.createExchange(exchangeContract, (ExchangeHandler)inOutHandler);
                } else {
                    exchangeIn = serviceRef.createExchange(exchangeContract);
                }
                Context contextIn = exchangeIn.getContext();
                for (Map.Entry<String, Object> entry : taskParameters.entrySet()) {
                    contextIn.setProperty(entry.getKey(), entry.getValue(), Scope.IN);
                }
                Message messageIn = exchangeIn.createMessage();
                String messageContentInName = this.getMessageContentInName();
                Object messageContentIn = taskParameters.get(messageContentInName);
                if (messageContentIn != null) {
                    messageIn.setContent(messageContentIn);
                }
                if (inOutHandler != null && ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    exchangeIn.send(messageIn);
                    try {
                        Exchange exchangeOut = inOutHandler.waitForOut();
                        Message messageOut = exchangeOut.getMessage();
                        Object messageContentOut = messageOut.getContent();
                        taskResults = task.getResults();
                        if (taskResults == null) {
                            taskResults = new HashMap<String, Object>();
                        }
                        String messageContentOutName = this.getMessageContentOutName();
                        taskResults.put(messageContentOutName, messageContentOut);
                        Context contextOut = exchangeOut.getContext();
                        for (Property property : contextOut.getProperties(Scope.OUT)) {
                            taskResults.put(property.getName(), property.getValue());
                        }
                    }
                    catch (DeliveryException e) {
                        problem = e.getMessage();
                    }
                } else {
                    exchangeIn.send(messageIn);
                }
            } else {
                problem = "serviceRef (" + serviceName + ") == null";
            }
        } else {
            problem = "ServiceName == null";
        }
        if (problem == null) {
            taskManager.completeTask(task.getId(), taskResults);
        } else {
            LOGGER.error((Object)problem);
            taskManager.abortTask(task.getId());
        }
    }

    private QName getServiceName(Map<String, Object> taskParameters) {
        String tns;
        QName serviceName = null;
        Object p = taskParameters.get(SERVICE_NAME);
        if (p instanceof QName) {
            serviceName = (QName)p;
        } else if (p instanceof String) {
            serviceName = XMLHelper.createQName((String)((String)p));
        }
        if (serviceName != null && Strings.trimToNull((String)serviceName.getNamespaceURI()) == null && (tns = this.getTargetNamespace()) != null) {
            serviceName = XMLHelper.createQName((String)tns, (String)serviceName.getLocalPart());
        }
        return serviceName;
    }

    private ExchangeContract getExchangeContract(ServiceReference serviceRef, Map<String, Object> taskParameters) {
        ExchangeContract exchangeContract;
        Object on = taskParameters.get(SERVICE_OPERATION_NAME);
        if (on instanceof String) {
            String operationName = (String)on;
            ServiceOperation operation = serviceRef.getInterface().getOperation(operationName);
            if (operation == null) {
                throw new RuntimeException("operationName [" + operationName + "] == null");
            }
            exchangeContract = new BaseExchangeContract(operation);
        } else {
            exchangeContract = ExchangeContract.IN_ONLY;
        }
        return exchangeContract;
    }
}

