/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.work;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.bpm.task.work.BaseTaskHandler;
import org.switchyard.component.bpm.task.work.Task;
import org.switchyard.component.bpm.task.work.TaskManager;
import org.switchyard.exception.DeliveryException;

public class SwitchYardServiceTaskHandler
extends BaseTaskHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceTaskHandler.class);
    public static final String SWITCHYARD_SERVICE = "SwitchYard Service";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String SERVICE_OPERATION_NAME = "ServiceOperationName";

    public SwitchYardServiceTaskHandler() {
        super(SWITCHYARD_SERVICE);
    }

    public SwitchYardServiceTaskHandler(String name) {
        super(name);
    }

    @Override
    public void executeTask(Task task, TaskManager manager) {
        String problem = null;
        Map<String, Object> parameters = task.getParameters();
        Map<String, Object> results = null;
        QName serviceName = this.getServiceName(parameters);
        if (serviceName != null) {
            ServiceReference serviceRef = this.getServiceDomain().getServiceReference(serviceName);
            if (serviceRef != null) {
                String operation = (String)parameters.get(SERVICE_OPERATION_NAME);
                SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
                Exchange exchangeIn = operation != null ? serviceRef.createExchange(operation, (ExchangeHandler)inOutHandler) : serviceRef.createExchange((ExchangeHandler)inOutHandler);
                Context contextIn = exchangeIn.getContext();
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    contextIn.setProperty(entry.getKey(), entry.getValue(), Scope.IN);
                }
                Message messageIn = exchangeIn.createMessage();
                String messageContentInName = this.getMessageContentInName();
                Object messageContentIn = parameters.get(messageContentInName);
                if (messageContentIn != null) {
                    messageIn.setContent(messageContentIn);
                }
                if (inOutHandler != null && ExchangePattern.IN_OUT.equals((Object)exchangeIn.getContract().getServiceOperation().getExchangePattern())) {
                    exchangeIn.send(messageIn);
                    try {
                        Exchange exchangeOut = inOutHandler.waitForOut();
                        Message messageOut = exchangeOut.getMessage();
                        Object messageContentOut = messageOut.getContent();
                        results = task.getResults();
                        if (results == null) {
                            results = new HashMap<String, Object>();
                        }
                        String messageContentOutName = this.getMessageContentOutName();
                        results.put(messageContentOutName, messageContentOut);
                        Context contextOut = exchangeOut.getContext();
                        for (Property property : contextOut.getProperties(Scope.OUT)) {
                            results.put(property.getName(), property.getValue());
                        }
                    }
                    catch (DeliveryException e) {
                        problem = e.getMessage();
                    }
                } else {
                    exchangeIn.send(messageIn);
                }
            } else {
                problem = "serviceRef (" + serviceName + ") == null";
            }
        } else {
            problem = "ServiceName == null";
        }
        if (problem == null) {
            manager.completeTask(task.getId(), results);
        } else {
            LOGGER.error((Object)problem);
            manager.abortTask(task.getId());
        }
    }

    private QName getServiceName(Map<String, Object> parameters) {
        String tns;
        QName serviceName = null;
        Object p = parameters.get(SERVICE_NAME);
        if (p instanceof QName) {
            serviceName = (QName)p;
        } else if (p instanceof String) {
            serviceName = XMLHelper.createQName((String)((String)p));
        }
        if (serviceName != null && Strings.trimToNull((String)serviceName.getNamespaceURI()) == null && (tns = this.getTargetNamespace()) != null) {
            serviceName = XMLHelper.createQName((String)tns, (String)serviceName.getLocalPart());
        }
        return serviceName;
    }
}

