/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.bpm;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.component.bpm.BPMOperationType;
import org.switchyard.component.bpm.config.model.v1.V1BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.v1.V1BPMOperationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.component.common.knowledge.config.model.OperationModel;
import org.switchyard.component.common.knowledge.config.model.OperationsModel;
import org.switchyard.component.common.knowledge.config.model.v1.V1ManifestModel;
import org.switchyard.component.common.knowledge.config.model.v1.V1OperationsModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.resource.ResourcesModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.resource.v1.V1ResourcesModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.forge.bpm.BPMFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.plugin.TemplateResource;

@Alias(value="bpm-service")
@RequiresProject
@RequiresFacet(value={BPMFacet.class, ResourceFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands related to BPM services in SwitchYard.")
public class BPMServicePlugin
implements Plugin {
    private static final String PROCESS_TEMPLATE = "ProcessTemplate.bpmn";
    private static final String PROCESS_EXTENSION = ".bpmn";
    private static final String PROCESS_DIR = "META-INF";
    private static final String VAR_PROCESS_ID = "${process.id}";
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="create", help="Created a new service backed by a BPM process.")
    public void newProcess(@Option(required=true, name="serviceName", description="The service name") String argServiceName, @Option(required=false, name="interfaceClass", description="The Java service interface") String argInterfaceClass, @Option(required=false, name="processDefinition", description="The business process definition") String argProcessFilePath, @Option(required=false, name="processId", description="The business process id") String argProcessId, @Option(required=false, name="persistent", description="The persistent flag") boolean argPersistent, PipeOut out) throws IOException {
        String processDefinitionPath;
        String processId;
        JavaSourceFacet java = (JavaSourceFacet)this._shell.getCurrentProject().getFacet(JavaSourceFacet.class);
        String pkgName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getTopLevelPackage();
        String interfaceClass = argInterfaceClass;
        if (interfaceClass == null) {
            if (pkgName == null) {
                pkgName = this._shell.promptCommon("Java package for service interface:", PromptType.JAVA_PACKAGE);
            }
            JavaInterface processInterface = (JavaInterface)((JavaInterface)((JavaInterface)((JavaInterface)JavaParser.create(JavaInterface.class)).setPackage(pkgName)).setName(argServiceName)).setPublic();
            processInterface.addMethod("void process(String content);");
            java.saveJavaSource((JavaSource)processInterface);
            interfaceClass = processInterface.getQualifiedName();
            out.println("Created service interface [" + interfaceClass + "]");
        }
        if ((processId = argProcessId) == null) {
            processId = argServiceName;
        }
        if ((processDefinitionPath = argProcessFilePath) == null) {
            processDefinitionPath = PROCESS_DIR + File.separator + argServiceName + PROCESS_EXTENSION;
            TemplateResource template = new TemplateResource(PROCESS_TEMPLATE).serviceName(argServiceName).replaceToken(VAR_PROCESS_ID, processId).packageName(pkgName);
            template.writeResource(((ResourceFacet)this._project.getFacet(ResourceFacet.class)).getResource(processDefinitionPath));
            out.println("Created process definition [" + processDefinitionPath + "]");
        }
        this.createImplementationConfig(argServiceName, interfaceClass, processId, argPersistent, processDefinitionPath);
        out.println("Process service " + argServiceName + " has been created.");
    }

    private void createImplementationConfig(String serviceName, String interfaceName, String processId, boolean persistent, String processDefinition) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        V1ComponentModel component = new V1ComponentModel();
        component.setName(serviceName);
        V1ComponentServiceModel service = new V1ComponentServiceModel();
        service.setName(serviceName);
        V1InterfaceModel csi = new V1InterfaceModel("java");
        csi.setInterface(interfaceName);
        service.setInterface((InterfaceModel)csi);
        component.addService((ComponentServiceModel)service);
        V1BPMComponentImplementationModel bpm = new V1BPMComponentImplementationModel();
        bpm.setProcessId(processId);
        bpm.setPersistent(persistent);
        V1OperationsModel operations = new V1OperationsModel("urn:switchyard-component-bpm:config:1.0");
        OperationModel operation = (OperationModel)new V1BPMOperationModel().setType(BPMOperationType.START_PROCESS).setName("operation");
        operations.addOperation(operation);
        bpm.setOperations((OperationsModel)operations);
        V1ManifestModel manifest = new V1ManifestModel("urn:switchyard-component-bpm:config:1.0");
        V1ResourcesModel resources = new V1ResourcesModel("urn:switchyard-component-bpm:config:1.0");
        resources.addResource(new V1ResourceModel("urn:switchyard-component-bpm:config:1.0").setLocation(processDefinition).setType(ResourceType.valueOf((String)"BPMN2")));
        manifest.setResources((ResourcesModel)resources);
        bpm.setManifest((ManifestModel)manifest);
        component.setImplementation((ComponentImplementationModel)bpm);
        SwitchYardModel syConfig = switchYard.getSwitchYardConfig();
        syConfig.getComposite().addComponent((ComponentModel)component);
        switchYard.saveConfig();
    }
}

