/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.common;

import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.config.model.composer.ContextMapperModel;
import org.switchyard.config.model.composer.MessageComposerModel;
import org.switchyard.config.model.composer.v1.V1ContextMapperModel;
import org.switchyard.config.model.composer.v1.V1MessageComposerModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.common.CommonFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="common")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CommonFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage Component Common Facility in SwitchYard.")
public class CommonPlugin
implements Plugin {
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="add-context-mapper", help="Add a context mapper to a service binding.")
    public void addContextMapper(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=false, name="className", description="The class name if you use your own ContextMapper implementation") String className, @Option(required=false, name="includes", description="Regular expression indicates which context property should be included") String includes, @Option(required=false, name="excludes", description="Regular expression indicates which context property should be excluded") String excludes, @Option(required=false, name="includeNamespaces", description="Regular expression indicates which context property namespaces should be included (if the property name is a qualified name)") String includeNamespaces, @Option(required=false, name="excludeNamespaces", description="Regular expression indicates which context property namespaces should be excluded (if the property name is a qualified name)") String excludeNamespaces, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = null;
        for (CompositeServiceModel s : switchYard.getSwitchYardConfig().getComposite().getServices()) {
            if (!s.getName().equals(serviceName)) continue;
            service = s;
        }
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "Service " + serviceName + " could not be found"));
            return;
        }
        if (service.getBindings().size() == 0) {
            out.println(out.renderColor(ShellColor.YELLOW, "No binding"));
            return;
        }
        ArrayList<String> bindingDescList = new ArrayList<String>();
        ArrayList bindingList = new ArrayList();
        for (BindingModel binding : service.getBindings()) {
            bindingList.add(BindingModel.class.cast(binding));
            bindingDescList.add(binding.getModelConfiguration().toString());
        }
        BindingModel binding = (BindingModel)bindingList.get(this._shell.promptChoice("Which binding to add", bindingDescList));
        String namespace = binding.getModelConfiguration().getQName().getNamespaceURI();
        V1ContextMapperModel model = new V1ContextMapperModel(namespace);
        if (className != null) {
            try {
                model.setClazz(className);
            }
            catch (Exception e) {
                out.println(out.renderColor(ShellColor.RED, e.getMessage()));
                return;
            }
        }
        model.setIncludes(includes);
        model.setExcludes(excludes);
        model.setIncludeNamespaces(includeNamespaces);
        model.setExcludeNamespaces(excludeNamespaces);
        binding.setContextMapper((ContextMapperModel)model);
        switchYard.saveConfig();
        out.println("ContextMapper successfully added to " + serviceName);
    }

    @Command(value="add-message-composer", help="Add a message composer to a service binding.")
    public void addMessageComposer(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=false, name="className", description="The class name if you use your own MessageComposer implementation") String className, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = null;
        for (CompositeServiceModel s : switchYard.getSwitchYardConfig().getComposite().getServices()) {
            if (!s.getName().equals(serviceName)) continue;
            service = s;
        }
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "Service " + serviceName + " could not be found"));
            return;
        }
        if (service.getBindings().size() == 0) {
            out.println(out.renderColor(ShellColor.YELLOW, "No binding"));
            return;
        }
        ArrayList<String> bindingDescList = new ArrayList<String>();
        ArrayList bindingList = new ArrayList();
        for (BindingModel binding : service.getBindings()) {
            bindingList.add(BindingModel.class.cast(binding));
            bindingDescList.add(binding.getModelConfiguration().toString());
        }
        BindingModel binding = (BindingModel)bindingList.get(this._shell.promptChoice("Which binding to add", bindingDescList));
        String namespace = binding.getModelConfiguration().getQName().getNamespaceURI();
        V1MessageComposerModel model = new V1MessageComposerModel(namespace);
        if (className != null) {
            try {
                model.setClazz(className);
            }
            catch (Exception e) {
                out.println(out.renderColor(ShellColor.RED, e.getMessage()));
                return;
            }
        }
        binding.setMessageComposer((MessageComposerModel)model);
        switchYard.saveConfig();
        out.println("MessageComposer successfully added to " + serviceName);
    }
}

