/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.http;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.http.config.model.HttpNamespace;
import org.switchyard.component.http.config.model.v1.V1BasicAuthModel;
import org.switchyard.component.http.config.model.v1.V1HttpBindingModel;
import org.switchyard.component.http.config.model.v1.V1NtlmAuthModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.common.CommonFacet;
import org.switchyard.tools.forge.http.HttpFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="http-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CommonFacet.class, HttpFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage HTTP service bindings in SwitchYard.")
public class HttpBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a HTTP binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=false, name="contextPath", description="The context root for this HTTP endpoint, defaults to [projectName]") String contextPath, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        V1HttpBindingModel binding = new V1HttpBindingModel(HttpNamespace.DEFAULT.uri());
        String projectName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getProjectName();
        if (contextPath != null && contextPath.length() > 0) {
            binding.setContextPath(contextPath);
        } else {
            binding.setContextPath(projectName);
        }
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.http to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a SOAP binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=true, name="address", description="The remote HTTP endpoint's address") String address, @Option(required=false, name="method", description="The HTTP method used for invoking the endpoint. Can be GET, POST, etc.,") String method, @Option(required=false, name="contentType", description="The HTTP Content-Type header value that identifies the body content") String contentType, @Option(required=false, name="user", description="The user name for authentication") String user, @Option(required=false, name="password", description="The password for authentication") String password, @Option(required=false, name="realm", description="The realm for authentication") String realm, @Option(required=false, name="domain", description="The NTLM domain for authentication") String domain, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        V1HttpBindingModel binding = new V1HttpBindingModel(HttpNamespace.DEFAULT.uri());
        if (address != null) {
            binding.setAddress(address);
        }
        if (method != null) {
            binding.setMethod(method);
        }
        if (contentType != null) {
            binding.setContentType(contentType);
        }
        if (domain != null) {
            V1NtlmAuthModel ntlm = new V1NtlmAuthModel(HttpNamespace.DEFAULT.uri());
            ntlm.setUser(user);
            ntlm.setPassword(password);
            ntlm.setRealm(realm);
            ntlm.setDomain(domain);
            binding.setNtlmAuthConfig(ntlm);
        } else {
            V1BasicAuthModel basic = new V1BasicAuthModel(HttpNamespace.DEFAULT.uri());
            basic.setUser(user);
            basic.setPassword(password);
            basic.setRealm(realm);
            binding.setBasicAuthConfig(basic);
        }
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.http to reference " + referenceName);
    }
}

