/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.remote;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.remote.config.model.v1.V1RemoteBindingModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.common.CommonFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.remote.RemoteFacet;

@Alias(value="remote-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CommonFacet.class, RemoteFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage Remote service bindings in SwitchYard.")
public class RemoteBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a Remote binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        V1RemoteBindingModel binding = new V1RemoteBindingModel();
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.remote to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a Remote binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        V1RemoteBindingModel binding = new V1RemoteBindingModel();
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.remote to reference " + referenceName);
    }
}

