/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange;

import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Context;
import org.switchyard.HandlerException;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.rules.common.RulesActionType;
import org.switchyard.component.rules.common.RulesConstants;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.exchange.RulesExchangeHandler;

public abstract class BaseRulesExchangeHandler
extends BaseHandler
implements RulesExchangeHandler {
    private static final Logger LOGGER = Logger.getLogger(BaseRulesExchangeHandler.class);

    protected RulesActionType getRulesActionType(Context context, RulesActionModel model) {
        RulesActionType rat;
        if (model != null && (rat = model.getType()) != null) {
            return rat;
        }
        Property property = context.getProperty(RulesConstants.ACTION_TYPE_VAR, Scope.EXCHANGE);
        if (property != null) {
            Object value = property.getValue();
            if (value instanceof RulesActionType) {
                return (RulesActionType)((Object)value);
            }
            if (value instanceof String) {
                return RulesActionType.fromAction((String)value);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            String msg = this.getNullParameterMessage(null, RulesConstants.ACTION_TYPE_VAR) + "; defaulting to: " + RulesActionType.EXECUTE.action();
            LOGGER.debug((Object)msg);
        }
        return RulesActionType.EXECUTE;
    }

    protected boolean isContinue(Context context) {
        return this.getBoolean(context, RulesConstants.CONTINUE_VAR, false);
    }

    protected boolean isDispose(Context context) {
        return this.getBoolean(context, RulesConstants.DISPOSE_VAR, false);
    }

    protected boolean getBoolean(Context context, String name, boolean fallback) {
        Property property = context.getProperty(name, Scope.EXCHANGE);
        if (property != null) {
            Object value = property.getValue();
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return fallback;
    }

    protected String getNullParameterMessage(RulesActionType rulesActionType, String parameterName) {
        StringBuilder sb = new StringBuilder("implementation.rules: ");
        if (rulesActionType != null) {
            sb.append("[");
            sb.append(rulesActionType.action());
            sb.append("] ");
        }
        sb.append(parameterName);
        sb.append(" == null");
        return sb.toString();
    }

    protected void throwNullParameterException(RulesActionType rulesActionType, String parameterName) throws HandlerException {
        throw new HandlerException(this.getNullParameterMessage(rulesActionType, parameterName));
    }
}

