/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.rules.Audit;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.v1.V1AuditModel;
import org.switchyard.component.rules.Channel;
import org.switchyard.component.rules.Execute;
import org.switchyard.component.rules.FireAllRules;
import org.switchyard.component.rules.FireUntilHalt;
import org.switchyard.component.rules.Rules;
import org.switchyard.component.rules.common.RulesActionType;
import org.switchyard.component.rules.config.model.ChannelModel;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1ChannelModel;
import org.switchyard.component.rules.config.model.v1.V1RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceInterfaceModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentReferenceInterfaceModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentServiceInterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class RulesSwitchYardScanner
implements Scanner<SwitchYardModel> {
    private static final IsAnnotationPresentFilter EXECUTE_FILTER = new IsAnnotationPresentFilter(Execute.class);
    private static final IsAnnotationPresentFilter FIRE_ALL_RULES_FILTER = new IsAnnotationPresentFilter(FireAllRules.class);
    private static final IsAnnotationPresentFilter FIRE_UNTIL_HALT_FILTER = new IsAnnotationPresentFilter(FireUntilHalt.class);
    private static final String UNDEFINED = "";
    private static final String INTERFACE_ERR_MSG = " is a class. @Rules only allowed on interfaces.";
    private final IsAnnotationPresentFilter _rulesFilter = new IsAnnotationPresentFilter(Rules.class);

    /*
     * WARNING - void declaration
     */
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        ClasspathScanner rulesScanner = new ClasspathScanner((Filter)this._rulesFilter);
        for (URL url : input.getURLs()) {
            rulesScanner.scan(url);
        }
        List rulesClasses = this._rulesFilter.getMatchedTypes();
        for (Class rulesClass : rulesClasses) {
            Rules rules = rulesClass.getAnnotation(Rules.class);
            Class rulesInterface = rules.value();
            if (Rules.UndefinedRulesInterface.class.equals((Object)rulesInterface)) {
                rulesInterface = rulesClass;
            }
            if (!rulesInterface.isInterface()) {
                throw new IOException(rulesInterface.getName() + INTERFACE_ERR_MSG);
            }
            String rulesName = rulesInterface.getSimpleName();
            V1ComponentModel componentModel = new V1ComponentModel();
            componentModel.setName(rulesName);
            V1RulesComponentImplementationModel rciModel = new V1RulesComponentImplementationModel();
            if (rules.agent()) {
                rciModel.setAgent(true);
            }
            rciModel.setClock(rules.clock());
            rciModel.setEventProcessing(rules.eventProcessing());
            int maxThreads = rules.maxThreads();
            if (maxThreads != -1) {
                rciModel.setMaxThreads(maxThreads);
            }
            rciModel.setMultithreadEvaluation(rules.multithreadEvaluation());
            String messageContentName = rules.messageContentName();
            if (!UNDEFINED.equals(messageContentName)) {
                rciModel.setMessageContentName(messageContentName);
            }
            JavaService javaService = JavaService.fromClass((Class)rulesInterface);
            for (Method method : rulesClass.getDeclaredMethods()) {
                ServiceOperation srvOper;
                void var20_31;
                Object var20_27 = null;
                String ep = null;
                if (EXECUTE_FILTER.matches(method)) {
                    RulesActionType rulesActionType = RulesActionType.EXECUTE;
                } else if (FIRE_ALL_RULES_FILTER.matches(method)) {
                    RulesActionType rulesActionType = RulesActionType.FIRE_ALL_RULES;
                } else if (FIRE_UNTIL_HALT_FILTER.matches(method)) {
                    RulesActionType rulesActionType = RulesActionType.FIRE_UNTIL_HALT;
                    ep = Strings.trimToNull((String)method.getAnnotation(FireUntilHalt.class).entryPoint());
                }
                if (var20_31 == null || (srvOper = javaService.getOperation(method.getName())) == null) continue;
                RulesActionModel ram = new V1RulesActionModel().setName(srvOper.getName()).setType((RulesActionType)var20_31).setEntryPoint(ep);
                rciModel.addRulesAction(ram);
            }
            Audit audit = rulesClass.getAnnotation(Audit.class);
            if (audit != null) {
                V1AuditModel v1AuditModel = new V1AuditModel(rciModel.getModelConfiguration().getQName().getNamespaceURI());
                v1AuditModel.setType(audit.type());
                int interval = audit.interval();
                if (interval != -1) {
                    v1AuditModel.setInterval(Integer.valueOf(interval));
                }
                if (!UNDEFINED.equals(audit.log())) {
                    v1AuditModel.setLog(audit.log());
                }
                rciModel.setAudit((AuditModel)v1AuditModel);
            }
            for (Channel channel : rules.channels()) {
                Class channelClass = channel.value();
                ChannelModel channelModel = new V1ChannelModel().setClazz(channelClass.getName());
                String channelName = channel.name();
                if (UNDEFINED.equals(channelName)) {
                    channelName = channelClass.getSimpleName();
                }
                channelModel.setName(channelName);
                if (!UNDEFINED.equals(channel.operation())) {
                    channelModel.setOperation(channel.operation());
                }
                if (!UNDEFINED.equals(channel.input())) {
                    channelModel.setInput(XMLHelper.createQName((String)channel.input()));
                }
                if (!UNDEFINED.equals(channel.reference())) {
                    String reference = channel.reference();
                    channelModel.setReference(reference);
                    V1ComponentReferenceModel compRefModel = new V1ComponentReferenceModel();
                    compRefModel.setName(reference);
                    if (!Channel.UndefinedInterface.class.equals((Object)channel.interfaze())) {
                        V1JavaComponentReferenceInterfaceModel compRefIfaceModel = new V1JavaComponentReferenceInterfaceModel();
                        compRefIfaceModel.setInterface(channel.interfaze().getName());
                        compRefModel.setInterface((ComponentReferenceInterfaceModel)compRefIfaceModel);
                        componentModel.addReference((ComponentReferenceModel)compRefModel);
                    }
                }
                rciModel.addChannel(channelModel);
            }
            for (String string : rules.resources()) {
                if (UNDEFINED.equals(string)) continue;
                rciModel.addResource(new V1ResourceModel("urn:switchyard-component-rules:config:1.0").setLocation(string));
            }
            componentModel.setImplementation((ComponentImplementationModel)rciModel);
            V1ComponentServiceModel v1ComponentServiceModel = new V1ComponentServiceModel();
            V1JavaComponentServiceInterfaceModel csiModel = new V1JavaComponentServiceInterfaceModel();
            csiModel.setInterface(rulesInterface.getName());
            v1ComponentServiceModel.setInterface((ComponentServiceInterfaceModel)csiModel);
            v1ComponentServiceModel.setName(rulesName);
            componentModel.addService((ComponentServiceModel)v1ComponentServiceModel);
            compositeModel.addComponent((ComponentModel)componentModel);
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }
}

