/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.rules;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.rules.RulesActionType;
import org.switchyard.component.rules.config.model.v1.V1RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.plugin.TemplateResource;
import org.switchyard.tools.forge.rules.RulesFacet;

@Alias(value="rules-service")
@RequiresProject
@RequiresFacet(value={RulesFacet.class, ResourceFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands related to rules services in SwitchYard.")
public class RulesServicePlugin
implements Plugin {
    private static final String RULES_TEMPLATE = "RulesTemplate.drl";
    private static final String RULES_EXTENSION = ".drl";
    private static final String RULES_DIR = "META-INF";
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="create", help="Created a new service backed by business rules.")
    public void newRules(@Option(required=true, name="serviceName", description="The service name") String argServiceName, @Option(required=false, name="interfaceClass", description="The Java service interface") String argInterfaceClass, @Option(required=false, name="ruleDefinition", description="The business rule definition") String argRuleFilePath, @Option(required=false, name="agent", description="Whether you want to use an agent to watch resources for changes (true|false)", defaultValue="false") Boolean argAgent, PipeOut out) throws IOException {
        String ruleDefinitionPath;
        JavaSourceFacet java = (JavaSourceFacet)this._shell.getCurrentProject().getFacet(JavaSourceFacet.class);
        String pkgName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getTopLevelPackage();
        String interfaceClass = argInterfaceClass;
        if (interfaceClass == null) {
            if (pkgName == null) {
                pkgName = this._shell.promptCommon("Java package for service interface:", PromptType.JAVA_PACKAGE);
            }
            JavaInterface ruleInterface = (JavaInterface)((JavaInterface)((JavaInterface)((JavaInterface)JavaParser.create(JavaInterface.class)).setPackage(pkgName)).setName(argServiceName)).setPublic();
            java.saveJavaSource((JavaSource)ruleInterface);
            interfaceClass = ruleInterface.getQualifiedName();
            out.println("Created service interface [" + interfaceClass + "]");
        }
        if ((ruleDefinitionPath = argRuleFilePath) == null) {
            ruleDefinitionPath = RULES_DIR + File.separator + argServiceName + RULES_EXTENSION;
            TemplateResource template = new TemplateResource(RULES_TEMPLATE).serviceName(argServiceName).packageName(pkgName);
            template.writeResource(((ResourceFacet)this._project.getFacet(ResourceFacet.class)).getResource(ruleDefinitionPath));
            out.println("Created rule definition [" + ruleDefinitionPath + "]");
        }
        boolean agent = argAgent != null ? argAgent : false;
        this.createImplementationConfig(argServiceName, interfaceClass, ruleDefinitionPath, agent);
        out.println("Rule service " + argServiceName + " has been created.");
    }

    private void createImplementationConfig(String serviceName, String interfaceName, String rulesDefinition, boolean agent) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        V1ComponentModel component = new V1ComponentModel();
        component.setName(serviceName);
        V1ComponentServiceModel service = new V1ComponentServiceModel();
        service.setName(serviceName);
        V1InterfaceModel csi = new V1InterfaceModel("java");
        csi.setInterface(interfaceName);
        service.setInterface((InterfaceModel)csi);
        component.addService((ComponentServiceModel)service);
        V1RulesComponentImplementationModel rules = new V1RulesComponentImplementationModel();
        rules.addResource(new V1ResourceModel("urn:switchyard-component-rules:config:1.0").setLocation(rulesDefinition));
        rules.addRulesAction(new V1RulesActionModel().setName("operation").setType(RulesActionType.EXECUTE));
        rules.setAgent(agent);
        component.setImplementation((ComponentImplementationModel)rules);
        SwitchYardModel syConfig = switchYard.getSwitchYardConfig();
        syConfig.getComposite().addComponent((ComponentModel)component);
        switchYard.saveConfig();
    }
}

