/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jca;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.RequestParamArgWithValue;
import org.jboss.as.cli.impl.RequestParameterArgument;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class BaseDataSourceModifyHandler
extends BaseOperationCommand {
    private final String dsType;
    private final ArgumentWithValue profile;
    private final ArgumentWithValue jndiName;

    public BaseDataSourceModifyHandler(String commandName, final String dsType) {
        super(commandName, true);
        this.dsType = dsType;
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.jndiName = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getDatasources(ctx.getModelControllerClient(), BaseDataSourceModifyHandler.this.profile.getValue(ctx.getParsedArguments()), dsType);
            }
        }), "--jndi-name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !BaseDataSourceModifyHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.initArguments();
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        this.setParams(ctx, steps);
        return composite;
    }

    @Override
    protected void setParams(CommandContext ctx, ModelNode request) throws CommandFormatException {
        String profile;
        ParsedArguments args = ctx.getParsedArguments();
        if (ctx.isDomainMode()) {
            profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
        } else {
            profile = null;
        }
        for (RequestParameterArgument arg : this.params) {
            String value = arg.getValue(args);
            if (value == null) continue;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            if (profile != null) {
                builder.addNode("profile", profile);
            }
            builder.addNode("subsystem", "datasources");
            builder.addNode(this.dsType, this.jndiName.getValue(args, true));
            builder.setOperationName("write-attribute");
            builder.addProperty("name", arg.getPropertyName());
            builder.addProperty("value", value);
            request.add(builder.buildRequest());
        }
    }

    private void initArguments() {
        this.initOptionalArguments(this.jndiName);
    }

    protected void initOptionalArguments(ArgumentWithoutValue lastRequired) {
        RequestParamArgWithValue maxPoolSize = new RequestParamArgWithValue("max-pool-size", (CommandHandlerWithArguments)this, new ValueCompleter("max-pool-size"));
        maxPoolSize.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue minPoolSize = new RequestParamArgWithValue("min-pool-size", (CommandHandlerWithArguments)this, new ValueCompleter("min-pool-size"));
        minPoolSize.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue poolPrefill = new RequestParamArgWithValue("pool-prefill", (CommandHandlerWithArguments)this, new ValueCompleter("pool-prefill"));
        poolPrefill.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue poolUseStrictMin = new RequestParamArgWithValue("pool-use-strict-min", (CommandHandlerWithArguments)this, new ValueCompleter("pool-use-strict-min"));
        poolUseStrictMin.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue blockingTimeoutWait = new RequestParamArgWithValue("blocking-timeout-wait-millis", (CommandHandlerWithArguments)this, new ValueCompleter("blocking-timeout-wait-millis"));
        blockingTimeoutWait.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue idleTimeout = new RequestParamArgWithValue("idle-timeout-minutes", (CommandHandlerWithArguments)this, new ValueCompleter("idle-timeout-minutes"));
        idleTimeout.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue backgroundValidation = new RequestParamArgWithValue("background-validation", (CommandHandlerWithArguments)this, new ValueCompleter("background-validation"));
        backgroundValidation.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue backgroundValidationMins = new RequestParamArgWithValue("background-validation-minutes", (CommandHandlerWithArguments)this, new ValueCompleter("background-validation-minutes"));
        backgroundValidationMins.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue useFastFail = new RequestParamArgWithValue("use-fast-fail", (CommandHandlerWithArguments)this, new ValueCompleter("use-fast-fail"));
        useFastFail.addRequiredPreceding(lastRequired);
    }

    public class ValueCompleter
    extends DefaultCompleter {
        public ValueCompleter(final String attrName) {
            super(new DefaultCompleter.CandidatesProvider(){

                @Override
                public List<String> getAllCandidates(CommandContext ctx) {
                    ModelControllerClient client = ctx.getModelControllerClient();
                    if (client == null) {
                        return Collections.emptyList();
                    }
                    DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                    if (ctx.isDomainMode()) {
                        String profileName = BaseDataSourceModifyHandler.this.profile.getValue(ctx.getParsedArguments());
                        if (profileName == null) {
                            return Collections.emptyList();
                        }
                        builder.addNode("profile", profileName);
                    }
                    builder.addNode("subsystem", "datasources");
                    String dsName = BaseDataSourceModifyHandler.this.jndiName.getValue(ctx.getParsedArguments());
                    if (dsName == null) {
                        return Collections.emptyList();
                    }
                    builder.addNode(BaseDataSourceModifyHandler.this.dsType, dsName);
                    builder.setOperationName("read-attribute");
                    builder.addProperty("name", attrName);
                    try {
                        ModelNode result = client.execute(builder.buildRequest());
                        if (!result.hasDefined("result")) {
                            return Collections.emptyList();
                        }
                        return Collections.singletonList(result.get("result").asString());
                    }
                    catch (Exception e) {
                        return Collections.emptyList();
                    }
                }
            });
        }
    }
}

