/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.Iterator;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.ValidatingOperationCallbackHandler;
import org.jboss.dmr.ModelNode;

public class DefaultOperationRequestBuilder
extends ValidatingOperationCallbackHandler
implements OperationRequestBuilder {
    private ModelNode request = new ModelNode();
    private OperationRequestAddress prefix;

    public DefaultOperationRequestBuilder() {
        this.prefix = new DefaultOperationRequestAddress();
    }

    public DefaultOperationRequestBuilder(OperationRequestAddress prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix can't be null");
        }
        this.prefix = new DefaultOperationRequestAddress(prefix);
    }

    public OperationRequestAddress getAddress() {
        return this.prefix;
    }

    @Override
    public void rootNode() {
        this.prefix.reset();
    }

    @Override
    public void parentNode() {
        this.prefix.toParentNode();
    }

    @Override
    public void nodeType() {
        this.prefix.toNodeType();
    }

    @Override
    public void nodeTypeNameSeparator(int index) {
    }

    @Override
    public void nodeSeparator(int index) {
    }

    @Override
    public void addressOperationSeparator(int index) {
    }

    @Override
    public void validatedOperationName(String operationName) {
        this.setOperationName(operationName);
    }

    @Override
    public void propertyListStart(int index) {
    }

    @Override
    public void propertyNameValueSeparator(int index) {
    }

    @Override
    public void propertySeparator(int index) {
    }

    @Override
    public void propertyListEnd(int index) {
    }

    @Override
    protected void validatedNodeType(String nodeType) throws OperationFormatException {
        this.addNodeType(nodeType);
    }

    @Override
    protected void validatedNodeName(String nodeName) throws OperationFormatException {
        this.addNodeName(nodeName);
    }

    @Override
    protected void validatedPropertyName(String propertyName) throws OperationFormatException {
        throw new OperationFormatException("Property '" + propertyName + "' is missing the value.");
    }

    @Override
    protected void validatedProperty(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        this.addProperty(name, value);
    }

    @Override
    public void nodeTypeOrName(String typeOrName) throws OperationFormatException {
        if (this.prefix.endsOnType()) {
            this.addNodeName(typeOrName);
        } else {
            this.addNodeType(typeOrName);
        }
    }

    @Override
    public ModelNode buildRequest() throws OperationFormatException {
        ModelNode address = this.request.get("address");
        if (this.prefix.isEmpty()) {
            address.setEmptyList();
        } else {
            Iterator iterator = this.prefix.iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    address.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("The node name is not specified for type '" + node.getType() + "'");
            }
        }
        if (!this.request.hasDefined("operation")) {
            throw new OperationFormatException("The operation name is missing or the format of the operation request is wrong.");
        }
        return this.request;
    }

    @Override
    public void setOperationName(String name) {
        this.request.get("operation").set(name);
    }

    @Override
    public void addNode(String type, String name) {
        this.prefix.toNode(type, name);
    }

    @Override
    public void addNodeType(String type) {
        this.prefix.toNodeType(type);
    }

    @Override
    public void addNodeName(String name) {
        this.prefix.toNode(name);
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified for " + name + ": '" + value + "'");
        }
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception e) {
            toSet = new ModelNode().set(value);
        }
        this.request.get(name).set(toSet);
    }

    public ModelNode getModelNode() {
        return this.request;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ModelNode.fromString((String)"(\"prop\"=>\"val\")").getType());
    }
}

