/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange;

import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Context;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.bpm.common.ProcessActionType;
import org.switchyard.component.bpm.common.ProcessConstants;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.exchange.BpmExchangeHandler;

public abstract class BaseBpmExchangeHandler
extends BaseHandler
implements BpmExchangeHandler {
    private static final Logger LOGGER = Logger.getLogger(BaseBpmExchangeHandler.class);

    protected ProcessActionType getProcessActionType(Context context, ProcessActionModel model) {
        ProcessActionType pat;
        if (model != null && (pat = model.getType()) != null) {
            return pat;
        }
        Property property = context.getProperty(ProcessConstants.PROCESS_ACTION_TYPE_VAR, Scope.IN);
        if (property != null) {
            Object value = property.getValue();
            if (value instanceof ProcessActionType) {
                return (ProcessActionType)((Object)value);
            }
            if (value instanceof QName) {
                return ProcessActionType.valueOf((QName)value);
            }
            if (value instanceof String) {
                return ProcessActionType.valueOf(XMLHelper.createQName((String)"urn:switchyard-component-bpm:process:1.0", (String)((String)value)));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            String msg = this.getNullParameterMessage(null, ProcessConstants.PROCESS_ACTION_TYPE_VAR) + "; defaulting to: " + ProcessActionType.START_PROCESS.qname();
            LOGGER.debug((Object)msg);
        }
        return ProcessActionType.START_PROCESS;
    }

    protected Long getProcessInstanceId(Context context) {
        Property property = context.getProperty(ProcessConstants.PROCESS_INSTANCE_ID_VAR, Scope.IN);
        if (property != null) {
            Object value = property.getValue();
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
        }
        return null;
    }

    protected String getProcessEventType(Context context, ProcessActionModel model) {
        String pet;
        if (model != null && (pet = model.getEventType()) != null) {
            return pet;
        }
        Property property = context.getProperty(ProcessConstants.PROCESS_EVENT_TYPE_VAR, Scope.IN);
        if (property != null) {
            Object value = property.getValue();
            if (value instanceof String) {
                return (String)value;
            }
            if (value != null) {
                return String.valueOf(value);
            }
        }
        return null;
    }

    protected Object getProcessEvent(Context context, Message message) {
        Property property = context.getProperty(ProcessConstants.PROCESS_EVENT_VAR, Scope.IN);
        if (property != null) {
            Object value = property.getValue();
            if (value != null) {
                return value;
            }
            if (message != null) {
                return message.getContent();
            }
        }
        return null;
    }

    protected String getNullParameterMessage(ProcessActionType processActionType, String parameterName) {
        StringBuilder sb = new StringBuilder("implementation.bpm: ");
        if (processActionType != null) {
            sb.append("[");
            sb.append(processActionType.qname());
            sb.append("] ");
        }
        sb.append(parameterName);
        sb.append(" == null");
        return sb.toString();
    }

    protected void throwNullParameterException(ProcessActionType processActionType, String parameterName) throws HandlerException {
        throw new HandlerException(this.getNullParameterMessage(processActionType, parameterName));
    }
}

