/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlImage
extends HtmlElement {
    private static final long serialVersionUID = -2304247017681577696L;
    private static final Log LOG = LogFactory.getLog(HtmlImage.class);
    public static final String TAG_NAME = "img";
    private int lastClickX_;
    private int lastClickY_;
    private WebResponse imageWebResponse_;
    private ImageReader imageReader_;
    private boolean downloaded_;
    private boolean onloadInvoked_;

    HtmlImage(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    protected void onAddedToPage() {
        this.doOnLoad();
        super.onAddedToPage();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String oldValue;
        if ("src".equals(qualifiedName) && value != ATTRIBUTE_NOT_DEFINED && this.getPage() instanceof HtmlPage && !(oldValue = this.getAttributeNS(namespaceURI, qualifiedName)).equals(value)) {
            this.onloadInvoked_ = false;
            this.downloaded_ = false;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void doOnLoad() {
        if (!(this.getPage() instanceof HtmlPage)) {
            return;
        }
        if (this.onloadInvoked_) {
            return;
        }
        this.onloadInvoked_ = true;
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        if (this.hasEventHandlers("onload")) {
            boolean ok;
            try {
                this.downloadImageIfNeeded();
                int i = this.imageWebResponse_.getStatusCode();
                ok = i >= 200 && i < 300 || i == 305;
            }
            catch (IOException e) {
                ok = false;
            }
            if (ok) {
                final Event event = new Event(this, "load");
                final Node scriptObject = (Node)this.getScriptObject();
                PostponedAction action = new PostponedAction(this.getPage()){

                    public void execute() throws Exception {
                        scriptObject.executeEvent(event);
                    }
                };
                String readyState = htmlPage.getReadyState();
                if ("loading".equals(readyState)) {
                    htmlPage.addAfterLoadAction(action);
                } else {
                    htmlPage.getWebClient().getJavaScriptEngine().addPostponedAction(action);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to download image for tag " + this + "; not firing onload event."));
            }
        }
    }

    public final String getSrcAttribute() {
        return this.getAttribute("src");
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttribute("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttribute("height");
    }

    public final String getWidthAttribute() {
        return this.getAttribute("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttribute("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttribute("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    public final String getBorderAttribute() {
        return this.getAttribute("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttribute("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttribute("vspace");
    }

    public int getHeight() throws IOException {
        this.readImageIfNeeded();
        return this.imageReader_.getHeight(0);
    }

    public int getWidth() throws IOException {
        this.readImageIfNeeded();
        return this.imageReader_.getWidth(0);
    }

    public ImageReader getImageReader() throws IOException {
        this.readImageIfNeeded();
        return this.imageReader_;
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded) {
            this.downloadImageIfNeeded();
        }
        return this.imageWebResponse_;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            HtmlPage page = (HtmlPage)this.getPage();
            WebClient webclient = page.getWebClient();
            URL url = page.getFullyQualifiedUrl(this.getSrcAttribute());
            WebRequest request = new WebRequest(url);
            request.setAdditionalHeader("Referer", page.getWebResponse().getWebRequest().getUrl().toExternalForm());
            this.imageWebResponse_ = webclient.loadWebResponse(request);
            this.downloaded_ = true;
        }
    }

    private void readImageIfNeeded() throws IOException {
        this.downloadImageIfNeeded();
        if (this.imageReader_ == null) {
            ImageInputStream iis = ImageIO.createImageInputStream(this.imageWebResponse_.getContentAsStream());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                throw new IOException("No image detected in response");
            }
            this.imageReader_ = iter.next();
            this.imageReader_.setInput(iis);
        }
    }

    public Page click(int x, int y) throws IOException {
        this.lastClickX_ = x;
        this.lastClickY_ = y;
        return super.click();
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected void doClickAction() throws IOException {
        HtmlAnchor anchor;
        if (this.getUseMapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String mapName = this.getUseMapAttribute().substring(1);
            HtmlElement doc = ((HtmlPage)this.getPage()).getDocumentElement();
            HtmlMap map = (HtmlMap)doc.getOneHtmlElementByAttribute("map", "name", mapName);
            for (HtmlElement element : map.getChildElements()) {
                HtmlArea area;
                if (!(element instanceof HtmlArea) || !(area = (HtmlArea)element).containsPoint(this.lastClickX_, this.lastClickY_)) continue;
                area.doClickAction();
                return;
            }
        }
        if ((anchor = (HtmlAnchor)this.getEnclosingElement("a")) == null) {
            return;
        }
        if (this.getIsmapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String suffix = "?" + this.lastClickX_ + "," + this.lastClickY_;
            anchor.doClickAction(suffix);
            return;
        }
        anchor.doClickAction();
    }

    public void saveAs(File file) throws IOException {
        ImageReader reader = this.getImageReader();
        ImageIO.write((RenderedImage)reader.read(0), reader.getFormatName(), file);
    }
}

