/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.parser;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.ws.common.JavaUtils;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.util.StAXUtils;

public class WSDeploymentAspectParser {
    private static final String NS = "urn:jboss:ws:deployment:aspects:1.0";
    private static final String DEPLOYMENT_ASPECTS = "deploymentAspects";
    private static final String DEPLOYMENT_ASPECT = "deploymentAspect";
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String MAP = "map";
    private static final String KEY_CLASS = "keyClass";
    private static final String VALUE_CLASS = "valueClass";
    private static final String ENTRY = "entry";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String LIST = "list";
    private static final String ELEMENT_CLASS = "elementClass";

    public static List<DeploymentAspect> parse(InputStream is, ClassLoader loader) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader((InputStream)is);
            return WSDeploymentAspectParser.parse(xmlr, loader);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static List<DeploymentAspect> parse(XMLStreamReader reader, ClassLoader loader) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        List<DeploymentAspect> deploymentAspects = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECTS)) {
                    deploymentAspects = WSDeploymentAspectParser.parseDeploymentAspects(reader, loader);
                    break;
                }
                throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
            }
        }
        return deploymentAspects;
    }

    private static List<DeploymentAspect> parseDeploymentAspects(XMLStreamReader reader, ClassLoader loader) throws XMLStreamException {
        LinkedList<DeploymentAspect> deploymentAspects = new LinkedList<DeploymentAspect>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECTS)) {
                        return deploymentAspects;
                    }
                    throw new IllegalStateException("Unexpected end tag: " + reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECT)) {
                        deploymentAspects.add(WSDeploymentAspectParser.parseDeploymentAspect(reader, loader));
                        break;
                    }
                    throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                }
            }
        }
        throw new IllegalStateException("Reached end of xml document unexpectedly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeploymentAspect parseDeploymentAspect(XMLStreamReader reader, ClassLoader loader) throws XMLStreamException {
        String deploymentAspectClass = reader.getAttributeValue(null, CLASS);
        if (deploymentAspectClass == null) {
            throw new IllegalStateException("Could not find class attribute for deployment aspect!");
        }
        DeploymentAspect deploymentAspect = null;
        try {
            Class<?> clazz = Class.forName(deploymentAspectClass, true, loader);
            ClassLoader orig = WSDeploymentAspectParser.getContextClassLoader();
            try {
                WSDeploymentAspectParser.setContextClassLoader(loader);
                deploymentAspect = (DeploymentAspect)clazz.newInstance();
            }
            finally {
                WSDeploymentAspectParser.setContextClassLoader(orig);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create a deploymeny aspect of class: " + deploymentAspectClass, e);
        }
        String priority = reader.getAttributeValue(null, PRIORITY);
        if (priority != null) {
            deploymentAspect.setRelativeOrder(Integer.parseInt(priority.trim()));
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECT)) {
                        return deploymentAspect;
                    }
                    throw new IllegalStateException("Unexpected end tag: " + reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)PROPERTY)) {
                        WSDeploymentAspectParser.parseProperty(reader, deploymentAspect, loader);
                        break;
                    }
                    throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                }
            }
        }
        throw new IllegalStateException("Reached end of xml document unexpectedly");
    }

    private static void parseProperty(XMLStreamReader reader, DeploymentAspect deploymentAspect, ClassLoader loader) throws XMLStreamException {
        Class<?> deploymentAspectClass = deploymentAspect.getClass();
        String propName = reader.getAttributeValue(null, NAME);
        if (propName == null) {
            throw new IllegalStateException("Could not find property name attribute for deployment aspect: " + deploymentAspect);
        }
        String propClass = reader.getAttributeValue(null, CLASS);
        if (propClass == null) {
            throw new IllegalStateException("Could not find property class attribute for deployment aspect: " + deploymentAspect);
        }
        try {
            if (WSDeploymentAspectParser.isSupportedPropertyClass(propClass)) {
                Method m = WSDeploymentAspectParser.selectMethod(deploymentAspectClass, propName, propClass);
                m.invoke((Object)deploymentAspect, WSDeploymentAspectParser.parseSimpleValue(reader, propClass));
                return;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)PROPERTY)) {
                        return;
                    }
                    throw new IllegalStateException("Unexpected end tag: " + reader.getLocalName());
                }
                case 1: {
                    Method m;
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)MAP)) {
                        try {
                            m = WSDeploymentAspectParser.selectMethod(deploymentAspectClass, propName, propClass);
                            Map map = WSDeploymentAspectParser.parseMapProperty(reader, propClass, reader.getAttributeValue(null, KEY_CLASS), reader.getAttributeValue(null, VALUE_CLASS), loader);
                            m.invoke((Object)deploymentAspect, map);
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)LIST)) {
                        try {
                            m = WSDeploymentAspectParser.selectMethod(deploymentAspectClass, propName, propClass);
                            List list = WSDeploymentAspectParser.parseListProperty(reader, propClass, reader.getAttributeValue(null, ELEMENT_CLASS));
                            m.invoke((Object)deploymentAspect, list);
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                }
            }
        }
        throw new IllegalStateException("Reached end of xml document unexpectedly");
    }

    private static Method selectMethod(Class<?> deploymentAspectClass, String propName, String propClass) throws ClassNotFoundException {
        Method[] methods;
        for (Method m : methods = deploymentAspectClass.getMethods()) {
            Class<?>[] pars;
            if (!m.getName().equals("set" + JavaUtils.capitalize((String)propName)) || (pars = m.getParameterTypes()).length != 1 || !propClass.equals(pars[0].getName()) && !pars[0].isAssignableFrom(Class.forName(propClass))) continue;
            return m;
        }
        return null;
    }

    private static boolean isSupportedPropertyClass(String propClass) {
        return String.class.getName().equals(propClass) || Boolean.class.getName().equals(propClass) || Integer.class.getName().equals(propClass) || JavaUtils.isPrimitive((String)propClass);
    }

    private static Object parseSimpleValue(XMLStreamReader reader, String propClass) throws XMLStreamException {
        if (String.class.getName().equals(propClass)) {
            return StAXUtils.elementAsString((XMLStreamReader)reader);
        }
        if (Boolean.class.getName().equals(propClass)) {
            return StAXUtils.elementAsBoolean((XMLStreamReader)reader);
        }
        if (Integer.class.getName().equals(propClass)) {
            return StAXUtils.elementAsInt((XMLStreamReader)reader);
        }
        if (Boolean.TYPE.getName().equals(propClass)) {
            return StAXUtils.elementAsBoolean((XMLStreamReader)reader);
        }
        throw new IllegalArgumentException("Unsupported property class: " + propClass);
    }

    private static List parseListProperty(XMLStreamReader reader, String propClass, String elementClass) throws XMLStreamException {
        List list = null;
        try {
            list = (List)Class.forName(propClass).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create list of type: " + propClass, e);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)LIST)) {
                        return list;
                    }
                    throw new IllegalStateException("Unexpected end tag: " + reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)VALUE)) {
                        list.add(WSDeploymentAspectParser.parseSimpleValue(reader, elementClass));
                        break;
                    }
                    throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                }
            }
        }
        throw new IllegalStateException("Reached end of xml document unexpectedly");
    }

    private static Map parseMapProperty(XMLStreamReader reader, String propClass, String keyClass, String valueClass, ClassLoader loader) throws XMLStreamException {
        Map map = null;
        try {
            map = (Map)Class.forName(propClass, true, loader).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create map of type: " + propClass, e);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)MAP)) {
                        return map;
                    }
                    throw new IllegalStateException("Unexpected end tag: " + reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)ENTRY)) {
                        WSDeploymentAspectParser.parseMapEntry(reader, map, keyClass, valueClass);
                        break;
                    }
                    throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                }
            }
        }
        throw new IllegalStateException("Reached end of xml document unexpectedly");
    }

    private static void parseMapEntry(XMLStreamReader reader, Map map, String keyClass, String valueClass) throws XMLStreamException {
        boolean keyStartDone = false;
        boolean valueStartDone = false;
        Object key = null;
        Object value = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)ENTRY) && keyStartDone && valueStartDone) {
                        map.put(key, value);
                        return;
                    }
                    throw new IllegalStateException("Unexpected end tag: " + reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)KEY)) {
                        keyStartDone = true;
                        key = WSDeploymentAspectParser.parseSimpleValue(reader, keyClass);
                        break;
                    }
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)VALUE)) {
                        valueStartDone = true;
                        value = WSDeploymentAspectParser.parseSimpleValue(reader, valueClass);
                        break;
                    }
                    throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                }
            }
        }
        throw new IllegalStateException("Reached end of xml document unexpectedly");
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

