/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.extensions.wsdl;

import java.util.HashSet;
import java.util.Set;
import org.switchyard.extensions.wsdl.WSDLReader;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.metadata.BaseService;
import org.switchyard.metadata.ServiceOperation;

public final class WSDLService
extends BaseService {
    public static final String TYPE = "wsdl";
    private static final String PORTTYPE = "wsdl.porttype";
    private String _wsdlLocation;

    private WSDLService(Set<ServiceOperation> operations, String wsdlLocation) {
        super(operations, TYPE);
        this._wsdlLocation = wsdlLocation;
    }

    public static WSDLService fromWSDL(String wsdlLocationURI) throws WSDLReaderException {
        int index = wsdlLocationURI.indexOf("#");
        if (index > 0) {
            String wsdlLocation = wsdlLocationURI.substring(0, index);
            String localPart = wsdlLocationURI.substring(index + 1);
            String portName = null;
            if (!localPart.contains(PORTTYPE)) {
                throw new WSDLReaderException("Invalid WSDL interface part " + wsdlLocationURI);
            }
            portName = localPart.substring(PORTTYPE.length() + 1, localPart.length() - 1);
            return WSDLService.fromWSDL(wsdlLocation, portName);
        }
        throw new WSDLReaderException("Invalid WSDL interface " + wsdlLocationURI);
    }

    public static WSDLService fromWSDL(String wsdlLocation, String portName) throws WSDLReaderException {
        WSDLReader reader = new WSDLReader();
        HashSet<ServiceOperation> ops = reader.readWSDL(wsdlLocation, portName);
        return new WSDLService(ops, wsdlLocation);
    }

    public String getWSDLLocation() {
        return this._wsdlLocation;
    }
}

