/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;

public class JDBC_PING
extends FILE_PING {
    @Property(description="The JDBC connection URL", writable=false)
    protected String connection_url = null;
    @Property(description="The JDBC connection username", writable=false)
    protected String connection_username = null;
    @Property(description="The JDBC connection password", writable=false)
    protected String connection_password = null;
    @Property(description="The JDBC connection driver name", writable=false)
    protected String connection_driver = null;
    @Property(description="If not empty, this SQL statement will be performed at startup.Customize it to create the needed table on those databases which permit table creation attempt without loosing data, such as PostgreSQL and MySQL (using IF NOT EXISTS). To allow for creation attempts, errors performing this statement will be loggedbut not considered fatal. To avoid any DDL operation, set this to an empty string.")
    protected String initialize_sql = "CREATE TABLE JGROUPSPING (own_addr varchar(200) NOT NULL, cluster_name varchar(200) NOT NULL, ping_data varbinary(5000) DEFAULT NULL, PRIMARY KEY (own_addr, cluster_name) )";
    @Property(description="SQL used to insert a new row. Customizable, but keep the order of parameters and pick compatible types: 1)Own Address, as String 2)Cluster name, as String 3)Serialized PingData as byte[]")
    protected String insert_single_sql = "INSERT INTO JGROUPSPING (own_addr, cluster_name, ping_data) values (?, ?, ?)";
    @Property(description="SQL used to delete a row. Customizable, but keep the order of parameters and pick compatible types: 1)Own Address, as String 2)Cluster name, as String")
    protected String delete_single_sql = "DELETE FROM JGROUPSPING WHERE own_addr=? AND cluster_name=?";
    @Property(description="SQL used to fetch all node's PingData. Customizable, but keep the order of parameters and pick compatible types: only one parameter needed, String compatible, representing the Cluster name. Must return a byte[], the Serialized PingData as it was stored by the insert_single_sql statement")
    protected String select_all_pingdata_sql = "SELECT ping_data FROM JGROUPSPING WHERE cluster_name=?";
    @Property(description="To use a DataSource registered in JNDI, specify the JNDI name here. This is an alternative to all connection_* configuration options: if this property is not empty, then all connection relatedproperties must be empty.")
    protected String datasource_jndi_name;
    private DataSource dataSourceFromJNDI = null;

    @Override
    public void init() throws Exception {
        super.init();
        this.verifyconfigurationParameters();
        if (JDBC_PING.stringIsEmpty(this.datasource_jndi_name)) {
            this.loadDriver();
        } else {
            this.dataSourceFromJNDI = this.getDataSourceFromJNDI(this.datasource_jndi_name.trim());
        }
        this.attemptSchemaInitialization();
    }

    @Override
    public void stop() {
        try {
            this.deleteSelf();
        }
        catch (SQLException e) {
            this.log.error("Error while unregistering of our own Address from JDBC_PING database during shutdown", e);
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSchemaInitialization() {
        block12: {
            if (JDBC_PING.stringIsEmpty(this.initialize_sql)) {
                this.log.info("Table creation step skipped: initialize_sql property is missing");
                return;
            }
            Connection connection = this.getConnection();
            if (connection != null) {
                try {
                    try {
                        PreparedStatement preparedStatement = connection.prepareStatement(this.initialize_sql);
                        preparedStatement.execute();
                        this.log.info("Table created for JDBC_PING Discovery Protocol");
                    }
                    catch (SQLException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Could not execute initialize_sql statement; not necessarily an error.", e);
                            break block12;
                        }
                        this.log.info("Could not execute initialize_sql statement; not necessarily an error. Set to debug logging level for details.");
                    }
                }
                finally {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.log.error("Error closing connection", e);
                    }
                }
            }
        }
    }

    protected void loadDriver() {
        if (JDBC_PING.stringIsEmpty(this.connection_driver)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registering JDBC Driver named '" + this.connection_driver + "'");
        }
        try {
            Class.forName(this.connection_driver);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("JDBC Driver required for JDBC_PING Discoveryprotocol could not be loaded: '" + this.connection_driver + "'");
        }
    }

    protected Connection getConnection() {
        if (this.dataSourceFromJNDI == null) {
            Connection connection;
            try {
                connection = DriverManager.getConnection(this.connection_url, this.connection_username, this.connection_password);
            }
            catch (SQLException e) {
                this.log.error("Could not open connection to database", e);
                return null;
            }
            if (connection == null) {
                this.log.error("Received null connection from the DriverManager!");
            }
            return connection;
        }
        try {
            return this.dataSourceFromJNDI.getConnection();
        }
        catch (SQLException e) {
            this.log.error("Could not open connection to database", e);
            return null;
        }
    }

    @Override
    protected void createRootDir() {
    }

    @Override
    protected void remove(String clustername, Address addr) {
        String addressAsString = this.addressAsString(addr);
        try {
            this.delete(clustername, addressAsString);
        }
        catch (SQLException e) {
            this.log.error("Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<PingData> readAll(String clustername) {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                List<PingData> list = this.readAll(connection, clustername);
                return list;
            }
            catch (SQLException e) {
                this.log.error("Error reading JDBC_PING table", e);
                List<PingData> list = Collections.emptyList();
                return list;
            }
            finally {
                this.closeConnection(connection);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PingData> readAll(Connection connection, String clustername) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(this.select_all_pingdata_sql);
        try {
            ps.setString(1, clustername);
            ResultSet resultSet = ps.executeQuery();
            ArrayList<PingData> results = new ArrayList<PingData>();
            while (resultSet.next()) {
                byte[] bytes = resultSet.getBytes(1);
                PingData pingData = this.deserialize(bytes);
                results.add(pingData);
            }
            ArrayList<PingData> arrayList = results;
            return arrayList;
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeToFile(PingData data, String clustername) {
        String ownAddress = this.addressAsString(data.getAddress());
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.delete(connection, clustername, ownAddress);
                this.insert(connection, data, clustername, ownAddress);
            }
            catch (SQLException e) {
                this.log.error("Error updating JDBC_PING table", e);
            }
            finally {
                this.closeConnection(connection);
            }
        } else {
            this.log.error("Failed to store PingData in database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Connection connection, PingData data, String clustername, String address) throws SQLException {
        byte[] serializedPingData = this.serializeWithoutView(data);
        PreparedStatement ps = connection.prepareStatement(this.insert_single_sql);
        try {
            ps.setString(1, address);
            ps.setString(2, clustername);
            ps.setBytes(3, serializedPingData);
            ps.executeUpdate();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered " + address + " for clustername " + clustername + " into database.");
            }
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(Connection connection, String clustername, String addressToDelete) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(this.delete_single_sql);
        try {
            ps.setString(1, addressToDelete);
            ps.setString(2, clustername);
            ps.executeUpdate();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Removed " + addressToDelete + " for clustername " + clustername + " from database.");
            }
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(String clustername, String addressToDelete) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.delete(connection, clustername, addressToDelete);
            }
            catch (SQLException e) {
                this.log.error("Error updating JDBC_PING table", e);
            }
            finally {
                this.closeConnection(connection);
            }
        } else {
            this.log.error("Failed to delete PingData in database");
        }
    }

    protected void deleteSelf() throws SQLException {
        String ownAddress = this.addressAsString(this.local_addr);
        this.delete(this.group_addr, ownAddress);
    }

    protected byte[] serializeWithoutView(PingData data) {
        PingData clone = new PingData(data.getAddress(), null, data.isServer(), data.getLogicalName(), data.getPhysicalAddrs());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            clone.writeTo(outputStream);
        }
        catch (IOException e) {
            this.log.error("Error", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected PingData deserialize(byte[] data) {
        PingData pingData = new PingData();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        DataInputStream outputStream = new DataInputStream(byteArrayInputStream);
        try {
            pingData.readFrom(outputStream);
        }
        catch (IllegalAccessException e) {
            this.log.error("Error", e);
        }
        catch (InstantiationException e) {
            this.log.error("Error", e);
        }
        catch (IOException e) {
            this.log.error("Error", e);
        }
        return pingData;
    }

    protected void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            this.log.error("Error closing connection to JDBC_PING database", e);
        }
    }

    protected DataSource getDataSourceFromJNDI(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object wathever = ctx.lookup(name);
            if (wathever == null) {
                throw new IllegalArgumentException("JNDI name " + name + " is not bound");
            }
            if (!(wathever instanceof DataSource)) {
                throw new IllegalArgumentException("JNDI name " + name + " was found but is not a DataSource");
            }
            DataSource dataSource = (DataSource)wathever;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Datasource found via JNDI lookup via name: '" + name + "'.");
            }
            DataSource dataSource2 = dataSource;
            return dataSource2;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Could not lookup datasource " + name, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    this.log.warn("Failed to close naming context.", e);
                }
            }
        }
    }

    protected void verifyconfigurationParameters() {
        if ((JDBC_PING.stringIsEmpty(this.connection_url) || JDBC_PING.stringIsEmpty(this.connection_driver) || JDBC_PING.stringIsEmpty(this.connection_url) || JDBC_PING.stringIsEmpty(this.connection_username)) && JDBC_PING.stringIsEmpty(this.datasource_jndi_name)) {
            throw new IllegalArgumentException("Either the 4 configuration properties starting with 'connection_' or the datasource_jndi_name must be set");
        }
        if ((JDBC_PING.stringNotEmpty(this.connection_url) || JDBC_PING.stringNotEmpty(this.connection_driver) || JDBC_PING.stringNotEmpty(this.connection_url) || JDBC_PING.stringNotEmpty(this.connection_username)) && JDBC_PING.stringNotEmpty(this.datasource_jndi_name)) {
            throw new IllegalArgumentException("When using the 'datasource_jndi_name' configuration property, all properties starting with 'connection_' must not be set");
        }
        if (JDBC_PING.stringIsEmpty(this.insert_single_sql)) {
            throw new IllegalArgumentException("The insert_single_sql configuration property is mandatory");
        }
        if (JDBC_PING.stringIsEmpty(this.delete_single_sql)) {
            throw new IllegalArgumentException("The delete_single_sql configuration property is mandatory");
        }
        if (JDBC_PING.stringIsEmpty(this.select_all_pingdata_sql)) {
            throw new IllegalArgumentException("The select_all_pingdata_sql configuration property is mandatory");
        }
    }

    private static final boolean stringIsEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    private static final boolean stringNotEmpty(String value) {
        return value != null && value.trim().length() >= 0;
    }
}

