/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PrioHeader;
import org.jgroups.stack.Protocol;

@Experimental
public class PRIO
extends Protocol {
    private PriorityBlockingQueue<PriorityMessage> downMessageQueue;
    private PriorityBlockingQueue<PriorityMessage> upMessageQueue;
    private DownMessageThread downMessageThread;
    private UpMessageThread upMessageThread;
    @Property(description="The number of miliseconds to sleep before after an error occurs before sending the next message")
    private int message_failure_sleep_time = 120000;
    @Property(description="true to prioritize outgoing messages")
    private boolean prioritize_down = true;
    @Property(description="true to prioritize incoming messages")
    private boolean prioritize_up = true;

    @Override
    public void start() throws Exception {
        if (this.prioritize_down) {
            this.downMessageQueue = new PriorityBlockingQueue<PriorityMessage>(100, new PriorityCompare());
            this.downMessageThread = new DownMessageThread(this, this.downMessageQueue);
            this.downMessageThread.start();
        }
        if (this.prioritize_up) {
            this.upMessageQueue = new PriorityBlockingQueue<PriorityMessage>(100, new PriorityCompare());
            this.upMessageThread = new UpMessageThread(this, this.upMessageQueue);
            this.upMessageThread.start();
        }
    }

    @Override
    public void stop() {
        if (this.downMessageThread != null) {
            this.downMessageThread.interrupt();
        }
        if (this.upMessageThread != null) {
            this.upMessageThread.interrupt();
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message message = (Message)evt.getArg();
                if (message.isFlagSet((byte)1)) {
                    return this.up_prot.up(evt);
                }
                PrioHeader hdr = (PrioHeader)message.getHeader(this.id);
                if (hdr != null) {
                    this.log.trace("Adding priority message " + hdr.getPriority() + " to UP queue");
                    this.upMessageQueue.add(new PriorityMessage(evt, hdr.getPriority()));
                    return null;
                }
                return this.up_prot.up(evt);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message message = (Message)evt.getArg();
                if (message.isFlagSet((byte)1)) {
                    return this.down_prot.down(evt);
                }
                PrioHeader hdr = (PrioHeader)message.getHeader(this.id);
                if (hdr != null) {
                    this.log.trace("Adding priority message " + hdr.getPriority() + " to DOWN queue");
                    this.downMessageQueue.add(new PriorityMessage(evt, hdr.getPriority()));
                    return null;
                }
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    private class PriorityCompare
    implements Comparator<PriorityMessage> {
        private PriorityCompare() {
        }

        @Override
        public int compare(PriorityMessage msg1, PriorityMessage msg2) {
            if (msg1.priority > msg2.priority) {
                return 1;
            }
            if (msg1.priority < msg2.priority) {
                return -1;
            }
            if (msg1.timestamp > msg2.timestamp) {
                return 1;
            }
            if (msg1.timestamp < msg2.timestamp) {
                return -1;
            }
            return 0;
        }
    }

    private abstract class MessageThread
    extends Thread {
        private PRIO prio;
        private PriorityBlockingQueue<PriorityMessage> messageQueue;

        private MessageThread(PRIO prio, PriorityBlockingQueue<PriorityMessage> messageQueue) {
            this.prio = prio;
            this.messageQueue = messageQueue;
            this.setName("PRIO " + (messageQueue == PRIO.this.downMessageQueue ? "down" : "up"));
        }

        protected abstract void handleMessage(PriorityMessage var1);

        @Override
        public void run() {
            while (true) {
                PriorityMessage priorityMessage = null;
                try {
                    priorityMessage = this.messageQueue.take();
                    this.handleMessage(priorityMessage);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    PRIO.this.log.error("Error handling message.  Sleeping " + this.prio.message_failure_sleep_time / 1000 + " seconds", e);
                    try {
                        MessageThread.sleep(this.prio.message_failure_sleep_time);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    this.messageQueue.add(priorityMessage);
                    continue;
                }
                break;
            }
        }
    }

    private class UpMessageThread
    extends MessageThread {
        private UpMessageThread(PRIO prio, PriorityBlockingQueue<PriorityMessage> messageQueue) {
            super(prio, messageQueue);
        }

        @Override
        protected void handleMessage(PriorityMessage message) {
            PRIO.this.log.trace("receiving priority " + message.priority + " message");
            PRIO.this.up_prot.up(message.event);
        }
    }

    private class DownMessageThread
    extends MessageThread {
        private DownMessageThread(PRIO prio, PriorityBlockingQueue<PriorityMessage> messageQueue) {
            super(prio, messageQueue);
        }

        @Override
        protected void handleMessage(PriorityMessage message) {
            PRIO.this.log.trace("Sending priority " + message.priority + " message");
            PRIO.this.down_prot.down(message.event);
        }
    }

    private class PriorityMessage {
        Event event;
        long timestamp;
        byte priority;

        private PriorityMessage(Event event, byte priority) {
            this.event = event;
            this.timestamp = System.currentTimeMillis();
            this.priority = priority;
        }
    }
}

