/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Result;

public class JarIndexer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result createJarIndex(File jarFile, Indexer indexer, boolean modify, boolean newJar, boolean verbose) throws IOException {
        File tmpCopy = null;
        ZipOutputStream zo = null;
        OutputStream out = null;
        File outputFile = null;
        JarFile jar = new JarFile(jarFile);
        if (modify) {
            tmpCopy = File.createTempFile(jarFile.getName().substring(0, jarFile.getName().lastIndexOf(46)), "jmp");
            zo = new ZipOutputStream(new FileOutputStream(tmpCopy));
            out = zo;
        } else if (newJar) {
            outputFile = new File(jarFile.getAbsolutePath().replace(".jar", "-jandex.jar"));
            zo = new ZipOutputStream(new FileOutputStream(outputFile));
            out = zo;
        } else {
            outputFile = new File(jarFile.getAbsolutePath().replace(".jar", "-jar") + ".idx");
            out = new FileOutputStream(outputFile);
        }
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (modify) {
                    zo.putNextEntry(entry);
                    JarIndexer.copy(jar.getInputStream(entry), zo);
                }
                if (!entry.getName().endsWith(".class")) continue;
                ClassInfo info = indexer.index(jar.getInputStream(entry));
                if (!verbose || info == null) continue;
                JarIndexer.printIndexEntryInfo(info);
            }
            if (modify || newJar) {
                zo.putNextEntry(new ZipEntry("META-INF/jandex.idx"));
            }
            IndexWriter writer = new IndexWriter(out);
            Index index = indexer.complete();
            int bytes = writer.write(index);
            if (modify) {
                jarFile.delete();
                tmpCopy.renameTo(jarFile);
                tmpCopy = null;
            }
            Result result = new Result(index, modify ? "META-INF/jandex.idx" : outputFile.getPath(), bytes);
            return result;
        }
        finally {
            out.flush();
            out.close();
            if (tmpCopy != null) {
                tmpCopy.delete();
            }
        }
    }

    private static void printIndexEntryInfo(ClassInfo info) {
        System.out.println("Indexed " + info.name() + " (" + info.annotations().size() + " annotations)");
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    private JarIndexer() {
    }
}

