/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.wsdl.WSDLLibrary;
import org.apache.cxf.wsdl.http.AddressType;

public final class BaseUrlHelper {
    private BaseUrlHelper() {
    }

    public static String getBaseURL(HttpServletRequest request) {
        String pathInfo;
        String reqPrefix = request.getRequestURL().toString();
        String string = pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            String basePath = request.getContextPath() + request.getServletPath();
            int index = basePath.length() == 0 ? reqPrefix.indexOf(request.getRequestURI()) : reqPrefix.indexOf(basePath);
            reqPrefix = reqPrefix.substring(0, index + basePath.length());
        }
        return reqPrefix;
    }

    public static void makeAddressesAbsolute(HttpServletRequest request, String baseAddress, AbstractDestination[] destinations) {
        for (AbstractDestination dest : destinations) {
            String addr = dest.getEndpointInfo().getAddress();
            if (addr == null || addr.length() == 0) {
                addr = "/";
            }
            if (addr == null || addr.startsWith("http")) continue;
            String base = baseAddress == null ? BaseUrlHelper.getBaseURL(request) : baseAddress;
            BaseUrlHelper.setAddress(dest, base + addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAddress(AbstractDestination dest, String absAddress) {
        AbstractDestination abstractDestination = dest;
        synchronized (abstractDestination) {
            dest.getEndpointInfo().setAddress(absAddress);
            if (WSDLLibrary.isAvailable() && dest.getEndpointInfo().getExtensor(AddressType.class) != null) {
                ((AddressType)dest.getEndpointInfo().getExtensor(AddressType.class)).setLocation(absAddress);
            }
        }
    }
}

