/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jboss.remoting3.remote.IntIndexer;

final class UnlockedReadIntIndexHashMap<V>
implements Iterable<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private final Object writeLock = new Object();
    private final float loadFactor;
    private final IntIndexer<? super V> indexer;
    private volatile int size;
    private volatile AtomicReferenceArray<V[]> table;
    private int threshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnlockedReadIntIndexHashMap(int initialCapacity, float loadFactor, IntIndexer<? super V> indexer) {
        int capacity;
        this.indexer = indexer;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be > 0");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be > 0.0f");
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        Object object = this.writeLock;
        synchronized (object) {
            this.threshold = (int)((float)capacity * loadFactor);
            this.table = new AtomicReferenceArray(capacity);
        }
    }

    UnlockedReadIntIndexHashMap(float loadFactor, IntIndexer<? super V> indexer) {
        this(512, loadFactor, indexer);
    }

    UnlockedReadIntIndexHashMap(int initialCapacity, IntIndexer<? super V> indexer) {
        this(initialCapacity, 0.6f, indexer);
    }

    UnlockedReadIntIndexHashMap(IntIndexer<? super V> indexer) {
        this(512, 0.6f, indexer);
    }

    private void resize() {
        assert (Thread.holdsLock(this.writeLock));
        AtomicReferenceArray<V[]> oldTable = this.table;
        int oldCapacity = oldTable.length();
        if (oldCapacity == 0x40000000) {
            return;
        }
        int newCapacity = oldCapacity << 1;
        AtomicReferenceArray<Object[]> newTable = new AtomicReferenceArray<Object[]>(newCapacity);
        int newThreshold = (int)((float)newCapacity * this.loadFactor);
        for (int i = 0; i < oldCapacity; ++i) {
            V[] items = oldTable.get(i);
            if (items == null) continue;
            IntIndexer<V> indexer = this.indexer;
            for (V item : items) {
                int hc = indexer.indexOf(item) & newCapacity - 1;
                Object[] old = (Object[])newTable.get(hc);
                if (old == null) {
                    Object[] newRow = new Object[]{item};
                    newTable.lazySet(hc, newRow);
                    continue;
                }
                int oldLen = old.length;
                Object[] copy = Arrays.copyOf(old, oldLen + 1);
                copy[oldLen] = item;
                newTable.lazySet(hc, copy);
            }
        }
        this.table = newTable;
        this.threshold = newThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doPut(AtomicReferenceArray<V[]> table, V value, boolean ifAbsent) {
        assert (Thread.holdsLock(this.writeLock));
        IntIndexer<V> indexer = this.indexer;
        int key = indexer.indexOf(value);
        int hc = key & table.length() - 1;
        V[] old = table.get(hc);
        if (old == null) {
            Object[] newRow = new Object[]{value};
            table.set(hc, newRow);
            if (this.size++ == this.threshold) {
                this.resize();
            }
            return null;
        }
        int oldLen = old.length;
        for (int i = 0; i < oldLen; ++i) {
            V v;
            block8: {
                V existing = old[i];
                if (!indexer.equals(existing, key)) continue;
                try {
                    v = existing;
                    if (ifAbsent) break block8;
                }
                catch (Throwable throwable) {
                    if (!ifAbsent) {
                        Object[] newRow = (Object[])old.clone();
                        newRow[i] = value;
                        table.set(hc, newRow);
                    }
                    throw throwable;
                }
                Object[] newRow = (Object[])old.clone();
                newRow[i] = value;
                table.set(hc, newRow);
            }
            return v;
        }
        V[] newRow = Arrays.copyOf(old, oldLen + 1);
        newRow[oldLen] = value;
        table.set(hc, newRow);
        if (this.size++ == this.threshold) {
            this.resize();
        }
        return null;
    }

    private static <V> V[] remove(V[] row, int idx) {
        int len = row.length;
        assert (idx < len);
        if (len == 1) {
            return null;
        }
        int lenMinusOne = len - 1;
        if (idx == lenMinusOne) {
            return Arrays.copyOf(row, idx);
        }
        Object[] newRow = new Object[lenMinusOne];
        if (idx > 0) {
            System.arraycopy(row, 0, newRow, 0, idx);
        }
        if (idx < lenMinusOne) {
            System.arraycopy(row, idx + 1, newRow, idx, lenMinusOne - idx);
        }
        return newRow;
    }

    public boolean containsKey(int key) {
        AtomicReferenceArray<V[]> table = this.table;
        int hc = key & table.length() - 1;
        V[] row = table.get(hc);
        if (row != null) {
            IntIndexer<V> indexer = this.indexer;
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                if (!indexer.equals(row[i], key)) continue;
                return true;
            }
        }
        return false;
    }

    public V get(int key) {
        AtomicReferenceArray<V[]> table = this.table;
        int hc = key & table.length() - 1;
        V[] row = table.get(hc);
        if (row != null) {
            IntIndexer<V> indexer = this.indexer;
            for (V value : row) {
                if (!indexer.equals(value, key)) continue;
                return value;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(V value) {
        Object object = this.writeLock;
        synchronized (object) {
            return this.doPut(this.table, value, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(V value) {
        Object object = this.writeLock;
        synchronized (object) {
            return this.doPut(this.table, value, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(int key) {
        IntIndexer<V> indexer = this.indexer;
        Object object = this.writeLock;
        synchronized (object) {
            AtomicReferenceArray<V[]> table = this.table;
            int hc = key & table.length() - 1;
            V[] row = table.get(hc);
            if (row == null) {
                return null;
            }
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                V item = row[i];
                if (!indexer.equals(item, key)) continue;
                table.set(hc, UnlockedReadIntIndexHashMap.remove(row, i));
                --this.size;
                return item;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(V value) {
        IntIndexer<V> indexer = this.indexer;
        int key = indexer.indexOf(value);
        Object object = this.writeLock;
        synchronized (object) {
            AtomicReferenceArray<V[]> table = this.table;
            int hc = key & table.length() - 1;
            V[] row = table.get(hc);
            if (row == null) {
                return false;
            }
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                V item = row[i];
                if (!indexer.equals(item, key) || !(value == null ? item == null : value.equals(item))) continue;
                table.set(hc, UnlockedReadIntIndexHashMap.remove(row, i));
                --this.size;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(V oldValue, V newValue) {
        IntIndexer<V> indexer = this.indexer;
        int key = indexer.indexOf(oldValue);
        if (indexer.indexOf(newValue) != key) {
            return false;
        }
        Object object = this.writeLock;
        synchronized (object) {
            AtomicReferenceArray<V[]> table = this.table;
            int hc = key & table.length() - 1;
            V[] row = table.get(hc);
            if (row == null) {
                return false;
            }
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                V existing = row[i];
                if (!indexer.equals(existing, key)) continue;
                if (existing == null ? oldValue == null : existing.equals(oldValue)) {
                    Object[] newRow = (Object[])row.clone();
                    newRow[i] = newValue;
                    table.set(hc, newRow);
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replace(V value) {
        IntIndexer<V> indexer = this.indexer;
        int key = indexer.indexOf(value);
        Object object = this.writeLock;
        synchronized (object) {
            AtomicReferenceArray<V[]> table = this.table;
            int hc = key & table.length() - 1;
            V[] row = table.get(hc);
            if (row == null) {
                return null;
            }
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                V existing = row[i];
                if (!indexer.equals(existing, key)) continue;
                Object[] newRow = (Object[])row.clone();
                Object oldValue = newRow[i];
                newRow[i] = value;
                table.set(hc, newRow);
                return (V)oldValue;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.writeLock;
        synchronized (object) {
            this.table = new AtomicReferenceArray(this.table.length());
            this.size = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private final AtomicReferenceArray<V[]> table;
            private int x;
            private int y;
            private V[] row;
            private V next;
            {
                this.table = UnlockedReadIntIndexHashMap.this.table;
                this.row = this.table.get(0);
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                int tableLength = this.table.length();
                if (this.x == tableLength) {
                    return false;
                }
                V[] row = this.row;
                if (row == null || this.y == row.length) {
                    ++this.x;
                    this.y = 0;
                    if (this.x == tableLength) {
                        return false;
                    }
                    row = this.table.get(this.x);
                    while (row == null || this.y == row.length) {
                        ++this.x;
                        if (this.x == tableLength) {
                            return false;
                        }
                        row = this.table.get(this.x);
                    }
                    this.row = row;
                }
                this.next = row[this.y++];
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object v = this.next;
                    return v;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

