/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.BundleInstallProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemServicesProvider;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.PackageAdminPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.osgi.framework.BundleContext;

public final class CoreServices
extends AbstractService<CoreServices> {
    static final Logger log = Logger.getLogger(CoreServices.class);
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    private final InjectedValue<BundleInstallProvider> injectedInstallProvider = new InjectedValue();
    private final InjectedValue<LifecycleInterceptorPlugin> injectedLifecycleInterceptor = new InjectedValue();
    private final InjectedValue<PackageAdminPlugin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<StartLevelPlugin> injectedStartLevel = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<SystemServicesProvider> injectedServicesProvider = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        CoreServices service = new CoreServices();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.CORE_SERVICES, (Service)service);
        builder.addDependency(Services.BUNDLE_INSTALL_PROVIDER, BundleInstallProvider.class, service.injectedInstallProvider);
        builder.addDependency(Services.FRAMEWORK_CREATE, FrameworkState.class, service.injectedFramework);
        builder.addDependency(InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN, LifecycleInterceptorPlugin.class, service.injectedLifecycleInterceptor);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdminPlugin.class, service.injectedPackageAdmin);
        builder.addDependency(Services.START_LEVEL, StartLevelPlugin.class, service.injectedStartLevel);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(Services.SYSTEM_SERVICES_PROVIDER, SystemServicesProvider.class, service.injectedServicesProvider);
        builder.addDependencies(new ServiceName[]{InternalServices.URL_HANDLER_PLUGIN, InternalServices.WEBXML_VERIFIER_PLUGIN});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private CoreServices() {
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting: %s", (Object)context.getController().getName());
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        SystemServicesProvider servicesProvider = (SystemServicesProvider)this.injectedServicesProvider.getValue();
        servicesProvider.registerSystemServices(systemContext);
        this.getFrameworkState().injectedCoreServices.inject((Object)this);
    }

    public void stop(StopContext context) {
        log.debugf("Stopping: %s", (Object)context.getController().getName());
        this.getFrameworkState().injectedCoreServices.uninject();
    }

    public CoreServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    BundleInstallProvider getInstallHandler() {
        return (BundleInstallProvider)this.injectedInstallProvider.getValue();
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getValue();
    }

    LifecycleInterceptorPlugin getLifecycleInterceptorPlugin() {
        return (LifecycleInterceptorPlugin)((Object)this.injectedLifecycleInterceptor.getValue());
    }

    PackageAdminPlugin getPackageAdmin() {
        return (PackageAdminPlugin)((Object)this.injectedPackageAdmin.getValue());
    }

    StartLevelPlugin getStartLevelPlugin() {
        return (StartLevelPlugin)((Object)this.injectedStartLevel.getValue());
    }
}

