/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.FragmentBundleState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.resolver.XFragmentHostRequirement;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.osgi.framework.BundleException;

final class FragmentBundleRevision
extends UserBundleRevision {
    private List<HostBundleRevision> attachedHosts;

    FragmentBundleRevision(FragmentBundleState bundleState, Deployment dep) throws BundleException {
        super(bundleState, dep);
    }

    static FragmentBundleRevision assertUserRevision(AbstractBundleRevision bundleRev) {
        if (bundleRev == null) {
            throw new IllegalArgumentException("Null bundleRev");
        }
        if (!(bundleRev instanceof FragmentBundleRevision)) {
            throw new IllegalArgumentException("Not an FragmentRevision: " + bundleRev);
        }
        return (FragmentBundleRevision)bundleRev;
    }

    @Override
    FragmentBundleState getBundleState() {
        return (FragmentBundleState)super.getBundleState();
    }

    @Override
    void refreshRevisionInternal(XModule resModule) {
        this.attachedHosts = null;
    }

    List<HostBundleRevision> getAttachedHosts() {
        if (this.attachedHosts == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.attachedHosts);
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("Cannot load class from a fragment: " + this);
    }

    @Override
    URL getResource(String resourceName) {
        return null;
    }

    @Override
    Enumeration<URL> getResources(String resourceName) throws IOException {
        return null;
    }

    void attachToHost() {
        if (this.attachedHosts == null) {
            this.attachedHosts = new CopyOnWriteArrayList<HostBundleRevision>();
        }
        for (XWire wire : this.getResolverModule().getWires()) {
            XRequirement req = wire.getRequirement();
            if (!(req instanceof XFragmentHostRequirement)) continue;
            XModule hostModule = wire.getExporter();
            HostBundleRevision hostRev = (HostBundleRevision)hostModule.getAttachment(AbstractBundleRevision.class);
            hostRev.attachFragment(this);
            this.attachedHosts.add(hostRev);
        }
    }

    @Override
    URL getLocalizationEntry(String path) {
        URL result = null;
        boolean fallbackToFragment = true;
        if (this.getResolverModule().isResolved()) {
            HostBundleRevision highest = null;
            for (HostBundleRevision hostrev : this.getAttachedHosts()) {
                if (highest == null) {
                    highest = hostrev;
                }
                if (highest.getVersion().compareTo((Object)hostrev.getVersion()) >= 0) continue;
                highest = hostrev;
            }
            if (highest == null) {
                throw new IllegalStateException("Cannot abtain attached host for: " + this);
            }
            boolean hostUninstalled = highest.getBundleState().isUninstalled();
            URL uRL = result = hostUninstalled ? this.getEntry(path) : highest.getLocalizationEntry(path);
            if (result != null || !fallbackToFragment) {
                return result;
            }
        }
        result = this.getEntry(path);
        return result;
    }
}

