/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleContext;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.LazyActivationTracker;
import org.jboss.osgi.framework.internal.ModuleActivatorBridge;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.modules.ModuleActivator;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

final class HostBundleState
extends UserBundleState {
    static final Logger log = Logger.getLogger(HostBundleState.class);
    private final Semaphore activationSemaphore = new Semaphore(1);
    private AtomicBoolean awaitLazyActivation;
    private BundleActivator bundleActivator;
    private int startLevel;

    HostBundleState(FrameworkState frameworkState, long bundleId, Deployment dep) {
        super(frameworkState, bundleId, dep);
    }

    static HostBundleState assertBundleState(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        if (!(bundleState instanceof HostBundleState)) {
            throw new IllegalArgumentException("Not a HostBundleState: " + bundleState);
        }
        return (HostBundleState)bundleState;
    }

    @Override
    void initUserBundleState(OSGiMetaData metadata) {
        StartLevelPlugin startLevelService = this.getCoreServices().getStartLevelPlugin();
        this.startLevel = startLevelService.getInitialBundleStartLevel();
        this.awaitLazyActivation = new AtomicBoolean(this.isActivationLazy());
    }

    @Override
    HostBundleContext createContextInternal() {
        return new HostBundleContext(this);
    }

    @Override
    HostBundleRevision createRevisionInternal(Deployment dep) throws BundleException {
        return new HostBundleRevision(this, dep);
    }

    @Override
    public BundleContext getBundleContext() {
        return super.getBundleContext();
    }

    @Override
    boolean isFragment() {
        return false;
    }

    int getStartLevel() {
        return this.startLevel;
    }

    void setStartLevel(int level) {
        this.startLevel = level;
    }

    @Override
    HostBundleRevision getCurrentRevision() {
        return (HostBundleRevision)super.getCurrentRevision();
    }

    boolean isPersistentlyStarted() {
        BundleStorageState storageState = this.getBundleStorageState();
        return storageState.isPersistentlyStarted();
    }

    boolean isActivationLazy() {
        ActivationPolicyMetaData activationPolicy = this.getActivationPolicy();
        String policyType = activationPolicy != null ? activationPolicy.getType() : null;
        return "lazy".equals(policyType);
    }

    ActivationPolicyMetaData getActivationPolicy() {
        return this.getOSGiMetaData().getBundleActivationPolicy();
    }

    boolean awaitLazyActivation() {
        return this.awaitLazyActivation.get();
    }

    void activateLazily() throws BundleException {
        if (this.awaitLazyActivation.getAndSet(false) && this.startLevelValidForStart()) {
            int options = 1;
            if (this.isBundleActivationPolicyUsed()) {
                options |= 2;
            }
            log.debugf("Lazy activation of: %s", (Object)this);
            this.startInternal(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        LazyActivationTracker.startTracking(this, className);
        try {
            Class<?> loadedClass = super.loadClass(className);
            LazyActivationTracker.processLoadedClass(loadedClass);
            Class<?> clazz = loadedClass;
            return clazz;
        }
        finally {
            LazyActivationTracker.stopTracking(this, className);
        }
    }

    private boolean startLevelValidForStart() {
        StartLevelPlugin startLevelPlugin = this.getCoreServices().getStartLevelPlugin();
        return this.getStartLevel() <= startLevelPlugin.getStartLevel();
    }

    private boolean isBundleActivationPolicyUsed() {
        BundleStorageState storageState = this.getBundleStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    private void setBundleActivationPolicyUsed(boolean usePolicy) {
        BundleStorageState storageState = this.getBundleStorageState();
        storageState.setBundleActivationPolicyUsed(usePolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startInternal(int options) throws BundleException {
        boolean useActivationPolicy;
        boolean bl = useActivationPolicy = (options & 2) != 0;
        if (!useActivationPolicy) {
            this.awaitLazyActivation.set(false);
        }
        this.assertStartConditions();
        if (!this.startLevelValidForStart()) {
            if ((options & 1) != 0) {
                throw new BundleException("Bundle cannot be started due to the Framework's current start level");
            }
            this.persistAutoStartSettings(options);
            return;
        }
        try {
            this.aquireActivationLock();
            if (this.getState() == 32) {
                return;
            }
            this.persistAutoStartSettings(options);
            if (!this.ensureResolved(true)) {
                throw new BundleException("Cannot resolve bundle: " + this);
            }
            if (this.getBundleContextInternal() == null) {
                this.createBundleContext();
            }
            if (this.awaitLazyActivation.get() && useActivationPolicy) {
                this.transitionToStarting(options);
            } else {
                this.transitionToActive(options);
            }
        }
        finally {
            this.releaseActivationLock();
        }
    }

    private void assertStartConditions() throws BundleException {
        List requiredEnvs = this.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (requiredEnvs != null) {
            boolean foundSupportedEnv = false;
            String frameworkEnvProp = (String)this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
            List<String> availableEnvs = Arrays.asList(frameworkEnvProp.split("[,\\s]+"));
            for (String aux : requiredEnvs) {
                if (!availableEnvs.contains(aux)) continue;
                foundSupportedEnv = true;
                break;
            }
            if (!foundSupportedEnv) {
                throw new BundleException("Unsupported execution environment " + requiredEnvs + " we have " + availableEnvs);
            }
        }
    }

    private void persistAutoStartSettings(int options) {
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
            boolean activationPolicyUsed = (options & 2) != 0;
            this.setBundleActivationPolicyUsed(activationPolicyUsed);
        }
    }

    private void setPersistentlyStarted(boolean started) {
        BundleStorageState storageState = this.getBundleStorageState();
        storageState.setPersistentlyStarted(started);
    }

    private void transitionToStarting(int options) throws BundleException {
        if (this.getState() == 8) {
            return;
        }
        this.changeState(8, 512);
    }

    private void transitionToActive(int options) throws BundleException {
        block9: {
            try {
                this.changeState(8);
            }
            catch (LifecycleInterceptorException ex) {
                throw new BundleException("Cannot transition to STARTING: " + this, (Throwable)ex);
            }
            XModule resModule = this.getResolverModule();
            String bundleActivatorClassName = resModule.getModuleActivator();
            if (bundleActivatorClassName != null) {
                try {
                    Object result = this.loadClass(bundleActivatorClassName).newInstance();
                    if (result instanceof ModuleActivator) {
                        this.bundleActivator = new ModuleActivatorBridge((ModuleActivator)result);
                        this.bundleActivator.start(this.getBundleContext());
                        break block9;
                    }
                    if (result instanceof BundleActivator) {
                        this.bundleActivator = (BundleActivator)result;
                        this.bundleActivator.start(this.getBundleContext());
                        break block9;
                    }
                    throw new BundleException(bundleActivatorClassName + " is not an implementation of " + BundleActivator.class.getName());
                }
                catch (Throwable th) {
                    this.changeState(16);
                    this.removeServicesAndListeners();
                    this.destroyBundleContext();
                    this.changeState(4);
                    if (th instanceof BundleException) {
                        throw (BundleException)th;
                    }
                    throw new BundleException("Cannot start bundle: " + this, th);
                }
            }
        }
        if (this.getState() == 1) {
            throw new BundleException("Bundle was uninstalled while activator was running: " + this);
        }
        this.changeState(32);
        this.getBundleManager().setServiceMode(this.getServiceName(32), ServiceController.Mode.ACTIVE);
        log.infof("Bundle started: %s", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopInternal(int options) throws BundleException {
        try {
            int priorState;
            this.aquireActivationLock();
            if (this.getState() == 1) {
                return;
            }
            if ((options & 1) == 0) {
                this.setPersistentlyStarted(false);
                this.setBundleActivationPolicyUsed(false);
            }
            if ((priorState = this.getState()) != 8 && priorState != 32) {
                return;
            }
            this.changeState(16);
            Throwable rethrow = null;
            if (priorState == 32 && this.bundleActivator != null) {
                try {
                    if (this.bundleActivator instanceof ModuleActivatorBridge) {
                        this.bundleActivator.stop(this.getBundleContext());
                    } else {
                        this.bundleActivator.stop(this.getBundleContext());
                    }
                }
                catch (Throwable t) {
                    rethrow = t;
                }
            }
            this.removeServicesAndListeners();
            if (this.getState() == 1) {
                throw new BundleException("Bundle uninstalled during activator stop: " + this);
            }
            this.destroyBundleContext();
            this.changeState(4, 4);
            this.getBundleManager().setServiceMode(this.getServiceName(32), ServiceController.Mode.NEVER);
            log.infof("Bundle stopped: %s", (Object)this);
            if (rethrow != null) {
                throw new BundleException("Error during stop of bundle: " + this, rethrow);
            }
        }
        finally {
            this.releaseActivationLock();
        }
    }

    private void aquireActivationLock() throws BundleException {
        try {
            log.tracef("Aquire activation lock: %s", (Object)this);
            if (!this.activationSemaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                throw new BundleException("Cannot acquire start/stop lock for: " + this);
            }
        }
        catch (InterruptedException ex) {
            log.warnf("Interupted while trying to start/stop bundle: %s", (Object)this);
            return;
        }
    }

    private void releaseActivationLock() {
        log.tracef("Release activation lock: %s", (Object)this);
        this.activationSemaphore.release();
    }

    private void removeServicesAndListeners() {
        for (ServiceState serviceState : this.getRegisteredServicesInternal()) {
            serviceState.unregisterInternal();
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.removeBundleListeners(this);
    }
}

