/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractExecutorService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FragmentBundleState;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public final class PackageAdminPlugin
extends AbstractExecutorService<PackageAdmin>
implements PackageAdmin {
    static final Logger log = Logger.getLogger(PackageAdminPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private final InjectedValue<ResolverPlugin> injectedResolver = new InjectedValue();
    private ServiceRegistration registration;

    static void addService(ServiceTarget serviceTarget) {
        PackageAdminPlugin service = new PackageAdminPlugin();
        ServiceBuilder builder = serviceTarget.addService(Services.PACKAGE_ADMIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, service.injectedFrameworkEvents);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, service.injectedModuleManager);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(InternalServices.RESOLVER_PLUGIN, ResolverPlugin.class, service.injectedResolver);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private PackageAdminPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(PackageAdmin.class.getName(), (Object)this, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
    }

    public PackageAdminPlugin getValue() {
        return this;
    }

    @Override
    ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi PackageAdmin refresh Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        if (bundle == null) {
            return this.getAllExportedPackages();
        }
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        if (bundleManager.getBundleById(bundle.getBundleId()) == null) {
            return null;
        }
        ArrayList<ExportedPackageImpl> result = new ArrayList<ExportedPackageImpl>();
        for (XModule resModule : bundleState.getAllResolverModules()) {
            if (!resModule.isResolved()) continue;
            for (XPackageCapability cap : resModule.getPackageCapabilities()) {
                result.add(new ExportedPackageImpl(cap));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    private ExportedPackage[] getAllExportedPackages() {
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        for (AbstractBundleState ab : bundleManager.getBundles()) {
            ExportedPackage[] pkgs = this.getExportedPackages(ab);
            if (pkgs == null) continue;
            result.addAll(Arrays.asList(pkgs));
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = this.getExportedPackagesInternal(name);
        if (pkgs.length == 0) {
            return null;
        }
        return pkgs;
    }

    private ExportedPackage[] getExportedPackagesInternal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        HashSet<ExportedPackageImpl> result = new HashSet<ExportedPackageImpl>();
        ResolverPlugin plugin = (ResolverPlugin)((Object)this.injectedResolver.getValue());
        for (XModule mod : plugin.getResolver().getModules()) {
            if (!mod.isResolved() || mod.isFragment()) continue;
            for (XCapability cap : mod.getCapabilities()) {
                if (!(cap instanceof XPackageCapability) || !name.equals(cap.getName())) continue;
                result.add(new ExportedPackageImpl((XPackageCapability)cap));
            }
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] exported = this.getExportedPackagesInternal(name);
        ArrayList<ExportedPackage> wired = new ArrayList<ExportedPackage>();
        ArrayList<ExportedPackage> notWired = new ArrayList<ExportedPackage>();
        for (ExportedPackage ep : exported) {
            XPackageCapability capability = ((ExportedPackageImpl)ep).getCapability();
            if (this.isWired(capability)) {
                wired.add(ep);
                continue;
            }
            notWired.add(ep);
        }
        ExportedPackageComparator comparator = new ExportedPackageComparator();
        Collections.sort(wired, comparator);
        Collections.sort(notWired, comparator);
        if (wired.size() > 0) {
            return (ExportedPackage)wired.get(0);
        }
        if (notWired.size() > 0) {
            return (ExportedPackage)notWired.get(0);
        }
        return null;
    }

    private boolean isWired(XPackageCapability capability) {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        for (AbstractBundleState ab : bundleManager.getBundles()) {
            for (XModule module : ab.getAllResolverModules()) {
                if (!module.isResolved()) continue;
                for (XWire wire : module.getWires()) {
                    if (!wire.getCapability().equals(capability)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void refreshPackages(final Bundle[] bundlesToRefresh) {
        final BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Bundle[] bundles = bundlesToRefresh;
                if (bundles == null) {
                    ArrayList<UserBundleState> bundlesToRefresh2 = new ArrayList<UserBundleState>();
                    for (AbstractBundleState aux : bundleManager.getBundles(null)) {
                        UserBundleState userBundle;
                        if (aux.getBundleId() == 0L || (userBundle = (UserBundleState)aux).getRevisions().size() <= 1 && aux.getState() != 1) continue;
                        bundlesToRefresh2.add(userBundle);
                    }
                    bundles = bundlesToRefresh2.toArray(new Bundle[bundlesToRefresh2.size()]);
                }
                HashMap<XModule, UserBundleState> refreshMap = new HashMap<XModule, UserBundleState>();
                for (Bundle aux : bundles) {
                    AbstractBundleState bundleState = AbstractBundleState.assertBundleState(aux);
                    if (!(bundleState instanceof UserBundleState)) continue;
                    for (XModule resModule : bundleState.getAllResolverModules()) {
                        refreshMap.put(resModule, (UserBundleState)bundleState);
                    }
                }
                HashSet<HostBundleState> stopBundles = new HashSet<HostBundleState>();
                HashSet<AbstractBundleState> refreshBundles = new HashSet<AbstractBundleState>();
                HashSet<UserBundleState> uninstallBundles = new HashSet<UserBundleState>();
                for (AbstractBundleState aux : refreshMap.values()) {
                    if (aux.getState() == 1) {
                        uninstallBundles.add((UserBundleState)aux);
                        continue;
                    }
                    if (!aux.isResolved()) continue;
                    refreshBundles.add(aux);
                }
                block10: for (AbstractBundleState aux : bundleManager.getBundles()) {
                    HostBundleState hostBundle;
                    XModule resModule;
                    if (!(aux instanceof HostBundleState) || !(resModule = (hostBundle = (HostBundleState)aux).getResolverModule()).isResolved()) continue;
                    for (XWire wire : resModule.getWires()) {
                        if (!refreshMap.containsKey(wire.getExporter())) continue;
                        int state = hostBundle.getState();
                        if (state == 32 || state == 8) {
                            stopBundles.add(hostBundle);
                        }
                        refreshBundles.add(hostBundle);
                        continue block10;
                    }
                }
                for (AbstractBundleState aux : new HashSet(refreshMap.values())) {
                    int state;
                    if (!(aux instanceof HostBundleState) || (state = aux.getState()) != 32 && state != 8) continue;
                    stopBundles.add((HostBundleState)aux);
                }
                ArrayList stopList = new ArrayList(stopBundles);
                ArrayList refreshList = new ArrayList(refreshBundles);
                BundleStartLevelComparator startLevelComparator = new BundleStartLevelComparator();
                Collections.sort(stopList, startLevelComparator);
                ListIterator it = stopList.listIterator(stopList.size());
                while (it.hasPrevious()) {
                    HostBundleState hostBundle = (HostBundleState)it.previous();
                    try {
                        hostBundle.stop(1);
                    }
                    catch (Exception th) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, th);
                    }
                }
                for (UserBundleState userBundle : uninstallBundles) {
                    bundleManager.removeBundle(userBundle, 0);
                }
                for (UserBundleState userBundle : refreshList) {
                    try {
                        userBundle.refresh();
                    }
                    catch (Exception th) {
                        eventsPlugin.fireFrameworkEvent(userBundle, 2, th);
                    }
                }
                for (HostBundleState hostBundle : stopList) {
                    try {
                        hostBundle.start(1);
                    }
                    catch (Exception th) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, th);
                    }
                }
                eventsPlugin.fireFrameworkEvent(bundleManager.getSystemBundle(), 4, null);
            }
        };
        this.getExecutorService().execute(runner);
    }

    public boolean resolveBundles(Bundle[] bundles) {
        ResolverPlugin resolverPlugin = (ResolverPlugin)((Object)this.injectedResolver.getValue());
        LinkedHashSet<XModule> unresolved = null;
        if (bundles != null) {
            unresolved = new LinkedHashSet<XModule>();
            for (Bundle aux : bundles) {
                AbstractBundleState bundleState = AbstractBundleState.assertBundleState(aux);
                XModuleIdentity moduleId = bundleState.getResolverModule().getModuleId();
                if (bundleState.getState() != 2 || resolverPlugin.getModuleById(moduleId) == null) continue;
                unresolved.add(bundleState.getResolverModule());
            }
        }
        log.debugf("Resolve bundles: %s", unresolved);
        return resolverPlugin.resolveAll(unresolved);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        HashMap matchingBundles = new HashMap();
        ArrayList<AbstractBundleState> bundles = new ArrayList<AbstractBundleState>(bundleManager.getBundles());
        if (symbolicName != null) {
            for (AbstractBundleState aux : bundles) {
                if (!symbolicName.equals(aux.getSymbolicName())) continue;
                matchingBundles.put(aux, new ArrayList());
            }
        } else {
            for (AbstractBundleState aux : bundles) {
                if (aux.isFragment()) continue;
                matchingBundles.put(aux, new ArrayList());
            }
        }
        if (matchingBundles.size() == 0) {
            return null;
        }
        for (AbstractBundleState aux : bundles) {
            XModule resModule = aux.getResolverModule();
            for (XRequireBundleRequirement req : resModule.getBundleRequirements()) {
                if (!req.getName().equals(symbolicName)) continue;
                for (XWire wire : req.getModule().getWires()) {
                    XCapability wiredCap;
                    XModule module;
                    Bundle bundle;
                    AbstractBundleState bundleState;
                    Collection requiring;
                    if (!wire.getRequirement().equals(req) || (requiring = (Collection)matchingBundles.get(bundleState = AbstractBundleState.assertBundleState(bundle = (Bundle)(module = (wiredCap = wire.getCapability()).getModule()).getAttachment(Bundle.class)))) == null) continue;
                    requiring.add(aux);
                }
            }
        }
        ArrayList<RequiredBundleImpl> result = new ArrayList<RequiredBundleImpl>(matchingBundles.size());
        for (Map.Entry entry : matchingBundles.entrySet()) {
            result.add(new RequiredBundleImpl((AbstractBundleState)entry.getKey(), (Collection)entry.getValue()));
        }
        return result.toArray(new RequiredBundle[matchingBundles.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        TreeSet<Bundle> sortedSet = new TreeSet<Bundle>(new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                return b2.getVersion().compareTo((Object)b1.getVersion());
            }
        });
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        for (AbstractBundleState bundleState : bundleManager.getBundles(symbolicName, versionRange)) {
            if (bundleState.getState() == 1) continue;
            sortedSet.add(bundleState);
        }
        if (sortedSet.isEmpty()) {
            return null;
        }
        return sortedSet.toArray(new Bundle[sortedSet.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        if (bundle.getBundleId() == 0L || bundleState.isFragment() || !bundleState.isResolved()) {
            return null;
        }
        HostBundleState hostBundle = HostBundleState.assertBundleState(bundleState);
        HostBundleRevision curRevision = hostBundle.getCurrentRevision();
        ArrayList<FragmentBundleState> result = new ArrayList<FragmentBundleState>();
        for (FragmentBundleRevision aux : curRevision.getAttachedFragments()) {
            result.add(aux.getBundleState());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle[] getHosts(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        if (!bundleState.isFragment()) {
            return null;
        }
        FragmentBundleState fragBundle = FragmentBundleState.assertBundleState(bundleState);
        FragmentBundleRevision curRevision = fragBundle.getCurrentRevision();
        ArrayList<HostBundleState> result = new ArrayList<HostBundleState>();
        for (HostBundleRevision aux : curRevision.getAttachedHosts()) {
            result.add(aux.getBundleState());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle getBundle(Class clazz) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue());
        AbstractBundleState bundleState = moduleManager.getBundleState(clazz);
        return bundleState != null ? bundleState : null;
    }

    public int getBundleType(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        return bundleState.isFragment() ? 1 : 0;
    }

    private static class ExportedPackageComparator
    implements Comparator<ExportedPackage> {
        private ExportedPackageComparator() {
        }

        @Override
        public int compare(ExportedPackage ep1, ExportedPackage ep2) {
            return ep2.getVersion().compareTo((Object)ep1.getVersion());
        }
    }

    private static class BundleStartLevelComparator
    implements Comparator<HostBundleState> {
        private BundleStartLevelComparator() {
        }

        @Override
        public int compare(HostBundleState o1, HostBundleState o2) {
            int sl2;
            int sl1 = o1.getStartLevel();
            return sl1 < (sl2 = o2.getStartLevel()) ? -1 : (sl1 == sl2 ? 0 : 1);
        }
    }

    static class RequiredBundleImpl
    implements RequiredBundle {
        private final Bundle requiredBundle;
        private final Bundle[] requiringBundles;
        private final AbstractBundleRevision bundleRevision;

        public RequiredBundleImpl(AbstractBundleState requiredBundle, Collection<AbstractBundleState> requiringBundles) {
            this.requiredBundle = AbstractBundleState.assertBundleState(requiredBundle);
            this.bundleRevision = requiredBundle.getCurrentRevision();
            ArrayList<AbstractBundleState> bundles = new ArrayList<AbstractBundleState>(requiringBundles.size());
            for (AbstractBundleState ab : requiringBundles) {
                bundles.add(AbstractBundleState.assertBundleState(ab));
            }
            this.requiringBundles = bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSymbolicName() {
            return this.requiredBundle.getSymbolicName();
        }

        public Bundle getBundle() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiredBundle;
        }

        public Bundle[] getRequiringBundles() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiringBundles;
        }

        public Version getVersion() {
            return this.requiredBundle.getVersion();
        }

        public boolean isRemovalPending() {
            if (this.requiredBundle.getState() == 1) {
                return true;
            }
            return !this.bundleRevision.equals(this.bundleRevision.getBundleState().getCurrentRevision());
        }
    }

    static class ExportedPackageImpl
    implements ExportedPackage {
        private final XPackageCapability capability;

        ExportedPackageImpl(XPackageCapability cap) {
            this.capability = cap;
        }

        public String getName() {
            return this.capability.getName();
        }

        public Bundle getExportingBundle() {
            Bundle bundle = (Bundle)this.capability.getModule().getAttachment(Bundle.class);
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
            return bundleState;
        }

        public Bundle[] getImportingBundles() {
            XBundleCapability bundleCap;
            Set bundleReqSet;
            if (this.isRemovalPending()) {
                return null;
            }
            XModule capModule = this.capability.getModule();
            if (!capModule.isResolved()) {
                return null;
            }
            HashSet reqset = new HashSet();
            Set pkgReqSet = this.capability.getWiredRequirements();
            if (pkgReqSet != null) {
                reqset.addAll(pkgReqSet);
            }
            if ((bundleReqSet = (bundleCap = capModule.getBundleCapability()).getWiredRequirements()) != null) {
                reqset.addAll(bundleReqSet);
            }
            HashSet<AbstractBundleState> bundles = new HashSet<AbstractBundleState>();
            for (XRequirement req : reqset) {
                XModule reqmod = req.getModule();
                Bundle bundle = (Bundle)reqmod.getAttachment(Bundle.class);
                AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
                bundles.add(bundleState);
            }
            Bundle capBundle = (Bundle)capModule.getAttachment(Bundle.class);
            AbstractBundleState capAbstractBundle = AbstractBundleState.assertBundleState(capBundle);
            bundles.remove(capAbstractBundle);
            return bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSpecificationVersion() {
            return this.capability.getVersion().toString();
        }

        public Version getVersion() {
            return this.capability.getVersion();
        }

        public boolean isRemovalPending() {
            XModule module = this.capability.getModule();
            AbstractBundleRevision rev = (AbstractBundleRevision)module.getAttachment(AbstractBundleRevision.class);
            Bundle b = (Bundle)module.getAttachment(Bundle.class);
            AbstractBundleState ab = AbstractBundleState.assertBundleState(b);
            return !ab.getCurrentRevision().equals(rev) || ab.getState() == 1;
        }

        private XPackageCapability getCapability() {
            return this.capability;
        }
    }
}

