/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class BundleTracker
implements BundleTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    final BundleTrackerCustomizer customizer;
    private volatile Tracked tracked;
    final int mask;

    private Tracked tracked() {
        return this.tracked;
    }

    public BundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        this.context = context;
        this.mask = stateMask;
        this.customizer = customizer == null ? this : customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Tracked t;
        BundleTracker bundleTracker = this;
        synchronized (bundleTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked = t = new Tracked();
            synchronized (tracked) {
                this.context.addBundleListener((BundleListener)t);
                Object[] bundles = this.context.getBundles();
                if (bundles != null) {
                    int length = bundles.length;
                    for (int i = 0; i < length; ++i) {
                        int state = bundles[i].getState();
                        if ((state & this.mask) != 0) continue;
                        bundles[i] = null;
                    }
                    t.setInitial(bundles);
                }
            }
            this.tracked = t;
        }
        t.trackInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Bundle[] bundles;
        Tracked outgoing;
        BundleTracker bundleTracker = this;
        synchronized (bundleTracker) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
            outgoing.close();
            bundles = this.getBundles();
            this.tracked = null;
            try {
                this.context.removeBundleListener((BundleListener)outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if (bundles != null) {
            for (int i = 0; i < bundles.length; ++i) {
                outgoing.untrack(bundles[i], null);
            }
        }
    }

    @Override
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        return bundle;
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            return (Bundle[])t.getTracked(new Bundle[length]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Bundle bundle) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(bundle);
        }
    }

    public void remove(Bundle bundle) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    class Tracked
    extends AbstractTracked
    implements SynchronousBundleListener {
        Tracked() {
        }

        public void bundleChanged(BundleEvent event) {
            if (this.closed) {
                return;
            }
            Bundle bundle = event.getBundle();
            int state = bundle.getState();
            if ((state & BundleTracker.this.mask) != 0) {
                this.track(bundle, event);
            } else {
                this.untrack(bundle, event);
            }
        }

        @Override
        Object customizerAdding(Object item, Object related) {
            return BundleTracker.this.customizer.addingBundle((Bundle)item, (BundleEvent)related);
        }

        @Override
        void customizerModified(Object item, Object related, Object object) {
            BundleTracker.this.customizer.modifiedBundle((Bundle)item, (BundleEvent)related, object);
        }

        @Override
        void customizerRemoved(Object item, Object related, Object object) {
            BundleTracker.this.customizer.removedBundle((Bundle)item, (BundleEvent)related, object);
        }
    }
}

