/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange.drools;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.ProcessRuntime;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.common.ProcessActionType;
import org.switchyard.component.bpm.common.ProcessConstants;
import org.switchyard.component.bpm.config.model.BpmComponentImplementationModel;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.TaskHandlerModel;
import org.switchyard.component.bpm.exchange.BaseBpmExchangeHandler;
import org.switchyard.component.bpm.task.TaskHandler;
import org.switchyard.component.bpm.task.drools.DroolsWorkItemHandler;
import org.switchyard.config.model.resource.ResourceModel;
import org.switchyard.metadata.ServiceOperation;

public class DroolsBpmExchangeHandler
extends BaseBpmExchangeHandler {
    private final ServiceDomain _serviceDomain;
    private String _processId;
    private String _messageContentName;
    private List<TaskHandler> _taskHandlers = new ArrayList<TaskHandler>();
    private Map<String, ProcessActionModel> _actions = new HashMap<String, ProcessActionModel>();
    private KnowledgeBase _kbase;
    private StatefulKnowledgeSession _ksession;

    public DroolsBpmExchangeHandler(ServiceDomain serviceDomain) {
        this._serviceDomain = serviceDomain;
    }

    @Override
    public void init(QName qname, BpmComponentImplementationModel model) {
        this._processId = model.getProcessId();
        this._messageContentName = model.getMessageContentName();
        if (this._messageContentName == null) {
            this._messageContentName = ProcessConstants.MESSAGE_CONTENT_VAR;
        }
        for (TaskHandlerModel tihm : model.getTaskHandlers()) {
            TaskHandler tih = (TaskHandler)Construction.construct(tihm.getClazz());
            String name = tihm.getName();
            if (name != null) {
                tih.setName(name);
            }
            tih.setMessageContentName(this._messageContentName);
            tih.setServiceDomain(this._serviceDomain);
            this._taskHandlers.add(tih);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.addResource(model.getProcessDefinition(), kbuilder);
        for (ResourceModel resource : model.getResources()) {
            this.addResource((org.switchyard.common.io.resource.Resource)resource, kbuilder);
        }
        this._kbase = kbuilder.newKnowledgeBase();
        for (ProcessActionModel pam : model.getProcessActions()) {
            this._actions.put(pam.getName(), pam);
        }
    }

    private void addResource(org.switchyard.common.io.resource.Resource resource, KnowledgeBuilder kbuilder) {
        if (resource != null) {
            Resource kres = ResourceFactory.newUrlResource((URL)resource.getLocationURL());
            org.switchyard.common.io.resource.ResourceType resourceType = resource.getType();
            if (resourceType == null) {
                resourceType = org.switchyard.common.io.resource.ResourceType.valueOf((String)"BPMN2");
            }
            ResourceType kresType = ResourceType.getResourceType((String)resourceType.getName());
            kbuilder.add(kres, kresType);
        }
    }

    @Override
    public void start(ServiceReference serviceRef) {
        this._ksession = this._kbase.newStatefulKnowledgeSession();
        WorkItemManager wim = this._ksession.getWorkItemManager();
        for (TaskHandler th : this._taskHandlers) {
            wim.registerWorkItemHandler(th.getName(), (WorkItemHandler)new DroolsWorkItemHandler((ProcessRuntime)this._ksession, th));
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (!ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            return;
        }
        Context context = exchange.getContext();
        ServiceOperation serviceOperation = exchange.getContract().getServiceOperation();
        ProcessActionModel processActionModel = this._actions.get(serviceOperation.getName());
        ProcessActionType processActionType = this.getProcessActionType(context, processActionModel);
        Message message = exchange.getMessage();
        Long processInstanceId = null;
        ProcessInstance processInstance = null;
        switch (processActionType) {
            case START_PROCESS: {
                if (this._processId != null) {
                    Object content = message.getContent();
                    if (content != null) {
                        HashMap<String, Object> parameters = new HashMap<String, Object>();
                        parameters.put(this._messageContentName, content);
                        processInstance = this._ksession.startProcess(this._processId, parameters);
                    } else {
                        processInstance = this._ksession.startProcess(this._processId);
                    }
                    processInstanceId = processInstance.getId();
                    break;
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_ID_VAR);
                break;
            }
            case SIGNAL_EVENT: {
                String processEventType = this.getProcessEventType(context, processActionModel);
                Object processEvent = this.getProcessEvent(context, message);
                processInstanceId = this.getProcessInstanceId(context);
                if (processInstanceId != null) {
                    this._ksession.signalEvent(processEventType, processEvent, processInstanceId.longValue());
                    break;
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_INSTANCE_ID_VAR);
                break;
            }
            case ABORT_PROCESS_INSTANCE: {
                processInstanceId = this.getProcessInstanceId(context);
                if (processInstanceId != null) {
                    this._ksession.abortProcessInstance(processInstanceId.longValue());
                    break;
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_INSTANCE_ID_VAR);
            }
        }
        if (processInstanceId != null) {
            context.setProperty(ProcessConstants.PROCESS_INSTANCE_ID_VAR, (Object)processInstanceId, Scope.OUT);
            ExchangePattern exchangePattern = serviceOperation.getExchangePattern();
            if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                if (processInstance == null) {
                    processInstance = this._ksession.getProcessInstance(processInstanceId.longValue());
                }
                message = exchange.createMessage();
                Object content = null;
                if (processInstance != null) {
                    content = ((WorkflowProcessInstance)processInstance).getVariable(this._messageContentName);
                }
                if (content != null) {
                    message.setContent(content);
                }
                exchange.send(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(ServiceReference serviceRef) {
        if (this._ksession != null) {
            try {
                this._ksession.halt();
            }
            finally {
                try {
                    this._ksession.dispose();
                }
                finally {
                    this._ksession = null;
                }
            }
        }
    }

    @Override
    public void destroy(ServiceReference serviceRef) {
        this._kbase = null;
        this._taskHandlers.clear();
        this._actions.clear();
        this._messageContentName = null;
        this._processId = null;
    }
}

