/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.jacorb.JacORBAttribute;
import org.jboss.as.jacorb.JacORBElement;
import org.jboss.as.jacorb.JacORBNamespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JacORBSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final JacORBSubsystemParser INSTANCE = new JacORBSubsystemParser();

    private JacORBSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "jacorb");
        EnumSet<JacORBElement> encountered = EnumSet.noneOf(JacORBElement.class);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (JacORBNamespace.forUri(reader.getNamespaceURI())) {
                case JacORB_1_0: {
                    JacORBElement element = JacORBElement.forName(reader.getLocalName());
                    if (!encountered.add(element) && element != JacORBElement.PROPERTY_CONFIG) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
                    }
                    switch (element) {
                        case ORB_CONFIG: {
                            this.parseORBConfig(reader, subsystem.get(JacORBElement.ORB_CONFIG.getLocalName()));
                            continue block11;
                        }
                        case POA_CONFIG: {
                            this.parsePOAConfig(reader, subsystem.get(JacORBElement.POA_CONFIG.getLocalName()));
                            continue block11;
                        }
                        case INTEROP_CONFIG: {
                            this.parseInteropConfig(reader, subsystem.get(JacORBElement.INTEROP_CONFIG.getLocalName()));
                            continue block11;
                        }
                        case SECURITY_CONFIG: {
                            this.parseSecurityConfig(reader, subsystem.get(JacORBElement.SECURITY_CONFIG.getLocalName()));
                            continue block11;
                        }
                        case PROPERTY_CONFIG: {
                            this.parseGenericProperty(reader, subsystem.get(JacORBElement.PROPERTY_CONFIG.getLocalName()));
                            continue block11;
                        }
                        case INITIALIZERS_CONFIG: {
                            this.parseInitializersConfig(reader, subsystem.get(JacORBElement.INITIALIZERS_CONFIG.getLocalName()));
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        nodes.add(subsystem);
    }

    private void parseORBConfig(XMLExtendedStreamReader reader, ModelNode orbConfig) throws XMLStreamException {
        EnumSet<JacORBAttribute[]> expectedAttributes = EnumSet.of(JacORBAttribute.ORB_NAME, new JacORBAttribute[]{JacORBAttribute.ORB_PRINT_VERSION, JacORBAttribute.ORB_GIOP_MINOR_VERSION, JacORBAttribute.ORB_USE_BOM, JacORBAttribute.ORB_USE_IMR, JacORBAttribute.ORB_CACHE_POA_NAMES, JacORBAttribute.ORB_CACHE_TYPECODES});
        this.parseAttributes(reader, orbConfig, expectedAttributes, null);
        EnumSet<JacORBElement> foundElements = EnumSet.noneOf(JacORBElement.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (JacORBNamespace.forUri(reader.getNamespaceURI())) {
                case JacORB_1_0: {
                    JacORBElement element = JacORBElement.forName(reader.getLocalName());
                    if (!foundElements.add(element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
                    }
                    switch (element) {
                        case ORB_CONNECTION_CONFIG: {
                            ModelNode subNode = orbConfig.get(JacORBElement.ORB_CONNECTION_CONFIG.getLocalName());
                            EnumSet<JacORBAttribute> attributes = EnumSet.of(JacORBAttribute.ORB_CONN_RETRIES, new JacORBAttribute[]{JacORBAttribute.ORB_CONN_RETRY_INTERVAL, JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT, JacORBAttribute.ORB_CONN_SERVER_TIMEOUT, JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS, JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE, JacORBAttribute.ORB_CONN_OUTBUF_SIZE, JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT});
                            this.parseAttributes(reader, subNode, attributes, null);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block7;
                        }
                        case ORB_NAMING_CONFIG: {
                            ModelNode subNode = orbConfig.get(JacORBElement.ORB_NAMING_CONFIG.getLocalName());
                            EnumSet<JacORBAttribute> attributes = EnumSet.of(JacORBAttribute.ORB_NAMING_ROOT_CONTEXT, JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC);
                            this.parseAttributes(reader, subNode, attributes, null);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePOAConfig(XMLExtendedStreamReader reader, ModelNode poaConfig) throws XMLStreamException {
        EnumSet<JacORBAttribute> expectedAttributes = EnumSet.of(JacORBAttribute.POA_MONITORING, JacORBAttribute.POA_QUEUE_WAIT, JacORBAttribute.POA_QUEUE_MIN, JacORBAttribute.POA_QUEUE_MAX);
        this.parseAttributes(reader, poaConfig, expectedAttributes, null);
        EnumSet<JacORBElement> foundElements = EnumSet.noneOf(JacORBElement.class);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (JacORBNamespace.forUri(reader.getNamespaceURI())) {
                case JacORB_1_0: {
                    JacORBElement element = JacORBElement.forName(reader.getLocalName());
                    if (!foundElements.add(element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
                    }
                    switch (element) {
                        case POA_REQUEST_PROC_CONFIG: {
                            ModelNode subNode = poaConfig.get(JacORBElement.POA_REQUEST_PROC_CONFIG.getLocalName());
                            EnumSet<JacORBAttribute> attributes = EnumSet.of(JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE, JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS);
                            this.parseAttributes(reader, subNode, attributes, EnumSet.copyOf(attributes));
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseInteropConfig(XMLExtendedStreamReader reader, ModelNode interopConfig) throws XMLStreamException {
        EnumSet<JacORBAttribute[]> expectedAttributes = EnumSet.of(JacORBAttribute.INTEROP_SUN, new JacORBAttribute[]{JacORBAttribute.INTEROP_COMET, JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES, JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING, JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE, JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION});
        this.parseAttributes(reader, interopConfig, expectedAttributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSecurityConfig(XMLExtendedStreamReader reader, ModelNode securityConfig) throws XMLStreamException {
        EnumSet<JacORBAttribute[]> expectedAttributes = EnumSet.of(JacORBAttribute.SECURITY_SUPPORT_SSL, new JacORBAttribute[]{JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR, JacORBAttribute.SECURITY_CLIENT_SUPPORTS, JacORBAttribute.SECURITY_CLIENT_REQUIRES, JacORBAttribute.SECURITY_SERVER_SUPPORTS, JacORBAttribute.SECURITY_SERVER_REQUIRES, JacORBAttribute.SECURITY_USE_DOMAIN_SF, JacORBAttribute.SECURITY_USE_DOMAIN_SSF});
        this.parseAttributes(reader, securityConfig, expectedAttributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseGenericProperty(XMLExtendedStreamReader reader, ModelNode orbProperties) throws XMLStreamException {
        String key = null;
        String val = null;
        EnumSet<JacORBAttribute> required = EnumSet.of(JacORBAttribute.PROP_KEY, JacORBAttribute.PROP_VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            JacORBAttribute attribute = JacORBAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PROP_KEY: {
                    key = value;
                    continue block4;
                }
                case PROP_VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        orbProperties.add(key, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseInitializersConfig(XMLExtendedStreamReader reader, ModelNode initConfig) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        initConfig.set(reader.getElementText().trim());
    }

    private void parseAttributes(XMLExtendedStreamReader reader, ModelNode node, EnumSet<JacORBAttribute> expectedAttributes, EnumSet<JacORBAttribute> requiredAttributes) throws XMLStreamException {
        EnumSet<JacORBAttribute> parsedAttributes = EnumSet.noneOf(JacORBAttribute.class);
        if (requiredAttributes == null) {
            requiredAttributes = EnumSet.noneOf(JacORBAttribute.class);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JacORBAttribute attribute = JacORBAttribute.forName(reader.getAttributeLocalName(i));
            if (!expectedAttributes.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (!parsedAttributes.add(attribute)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
            }
            requiredAttributes.remove((Object)attribute);
            node.get(attribute.getLocalName()).set(attrValue);
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        String initializers;
        String property;
        String securityConfig;
        String interopConfig;
        String poaConfig;
        context.startSubsystemElement(JacORBNamespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        String orbConfig = JacORBElement.ORB_CONFIG.getLocalName();
        if (node.hasDefined(orbConfig)) {
            this.writeORBConfig(writer, node.get(orbConfig));
        }
        if (node.hasDefined(poaConfig = JacORBElement.POA_CONFIG.getLocalName())) {
            this.writePOAConfig(writer, node.get(poaConfig));
        }
        if (node.hasDefined(interopConfig = JacORBElement.INTEROP_CONFIG.getLocalName())) {
            this.writeInteropConfig(writer, node.get(interopConfig));
        }
        if (node.hasDefined(securityConfig = JacORBElement.SECURITY_CONFIG.getLocalName())) {
            this.writeSecurityConfig(writer, node.get(securityConfig));
        }
        if (node.hasDefined(property = JacORBElement.PROPERTY_CONFIG.getLocalName()) && node.get(property).asInt() > 0) {
            this.writeGenericProperties(writer, node.get(property));
        }
        if (node.hasDefined(initializers = JacORBElement.INITIALIZERS_CONFIG.getLocalName())) {
            this.writeInitializersConfig(writer, node.get(initializers));
        }
        writer.writeEndElement();
    }

    private void writeORBConfig(XMLExtendedStreamWriter writer, ModelNode orbConfig) throws XMLStreamException {
        String orbNamingConfigName;
        ModelNode clone = orbConfig.clone();
        ModelNode orbConnectionConfig = null;
        ModelNode orbNamingConfig = null;
        String orbConnConfigName = JacORBElement.ORB_CONNECTION_CONFIG.getLocalName();
        if (clone.hasDefined(orbConnConfigName)) {
            orbConnectionConfig = clone.get(orbConnConfigName);
            clone.remove(orbConnConfigName);
        }
        if (clone.hasDefined(orbNamingConfigName = JacORBElement.ORB_NAMING_CONFIG.getLocalName())) {
            orbNamingConfig = clone.get(orbNamingConfigName);
            clone.remove(orbNamingConfigName);
        }
        if (orbConnectionConfig == null && orbNamingConfig == null) {
            writer.writeEmptyElement(JacORBElement.ORB_CONFIG.getLocalName());
            this.writeAttributes(writer, clone);
        } else {
            writer.writeStartElement(JacORBElement.ORB_CONFIG.getLocalName());
            this.writeAttributes(writer, clone);
            if (orbConnectionConfig != null) {
                writer.writeEmptyElement(orbConnConfigName);
                this.writeAttributes(writer, orbConnectionConfig);
            }
            if (orbNamingConfig != null) {
                writer.writeEmptyElement(orbNamingConfigName);
                this.writeAttributes(writer, orbNamingConfig);
            }
            writer.writeEndElement();
        }
    }

    private void writePOAConfig(XMLExtendedStreamWriter writer, ModelNode poaConfig) throws XMLStreamException {
        ModelNode clone = poaConfig.clone();
        ModelNode poaRequestProcessorsConfig = null;
        String poaRequestProcessorsConfigName = JacORBElement.POA_REQUEST_PROC_CONFIG.getLocalName();
        if (clone.hasDefined(poaRequestProcessorsConfigName)) {
            poaRequestProcessorsConfig = clone.get(poaRequestProcessorsConfigName);
            clone.remove(poaRequestProcessorsConfigName);
        }
        if (poaRequestProcessorsConfig == null) {
            writer.writeEmptyElement(JacORBElement.POA_CONFIG.getLocalName());
            this.writeAttributes(writer, clone);
        } else {
            writer.writeStartElement(JacORBElement.POA_CONFIG.getLocalName());
            this.writeAttributes(writer, clone);
            writer.writeEmptyElement(poaRequestProcessorsConfigName);
            this.writeAttributes(writer, poaRequestProcessorsConfig);
            writer.writeEndElement();
        }
    }

    private void writeInteropConfig(XMLExtendedStreamWriter writer, ModelNode interopConfig) throws XMLStreamException {
        writer.writeEmptyElement(JacORBElement.INTEROP_CONFIG.getLocalName());
        this.writeAttributes(writer, interopConfig);
    }

    private void writeSecurityConfig(XMLExtendedStreamWriter writer, ModelNode securityConfig) throws XMLStreamException {
        writer.writeEmptyElement(JacORBElement.SECURITY_CONFIG.getLocalName());
        this.writeAttributes(writer, securityConfig);
    }

    private void writeGenericProperties(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (Property prop : modelNode.asPropertyList()) {
            writer.writeEmptyElement(JacORBElement.PROPERTY_CONFIG.getLocalName());
            writer.writeAttribute(JacORBAttribute.PROP_KEY.getLocalName(), prop.getName());
            writer.writeAttribute(JacORBAttribute.PROP_VALUE.getLocalName(), prop.getValue().asString());
        }
    }

    private void writeInitializersConfig(XMLExtendedStreamWriter writer, ModelNode initConfig) throws XMLStreamException {
        writer.writeStartElement(JacORBElement.INITIALIZERS_CONFIG.getLocalName());
        writer.writeCharacters(initConfig.asString());
        writer.writeEndElement();
    }

    private void writeAttributes(XMLExtendedStreamWriter writer, ModelNode attributes) throws XMLStreamException {
        if (attributes.asInt() > 0) {
            for (Property property : attributes.asPropertyList()) {
                writer.writeAttribute(property.getName(), property.getValue().asString());
            }
        }
    }
}

