/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashMap;
import java.util.Map;

public enum ORBInitializer {
    UNKNOWN(null, null),
    CODEBASE("Codebase", "org.jboss.as.jacorb.codebase.CodebaseInterceptorInitializer"),
    CSIV2("CSIv2", "org.jboss.as.jacorb.csiv2.CSIv2Initializer"),
    SAS("SAS", "org.jboss.as.jacorb.csiv2.SASInitializer");

    private String initializerName;
    private String initializerClass;
    private static final Map<String, ORBInitializer> MAP;

    private ORBInitializer(String initializerName, String initializerClass) {
        this.initializerName = initializerName;
        this.initializerClass = initializerClass;
    }

    public String getInitializerName() {
        return this.initializerName;
    }

    public String getInitializerClass() {
        return this.initializerClass;
    }

    static ORBInitializer getInitializer(String initializerName) {
        ORBInitializer element = MAP.get(initializerName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, ORBInitializer> map = new HashMap<String, ORBInitializer>();
        for (ORBInitializer element : ORBInitializer.values()) {
            String name = element.getInitializerName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

