/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.service;

import org.jacorb.config.Configuration;
import org.jacorb.naming.NamingContextImpl;
import org.jboss.as.jacorb.service.CorbaServiceUtil;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class CorbaNamingService
implements Service<NamingContextExt> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jacorb");
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jacorb", "naming-service"});
    private InjectedValue<POA> rootPOAInjector = new InjectedValue();
    private InjectedValue<POA> namingPOAInjector = new InjectedValue();
    private InjectedValue<ORB> orbInjector = new InjectedValue();
    private NamingContextExt namingService;

    public void start(StartContext context) throws StartException {
        log.debugf("Starting Service " + context.getController().getName().getCanonicalName(), new java.lang.Object[0]);
        ORB orb = (ORB)this.orbInjector.getValue();
        POA rootPOA = (POA)this.rootPOAInjector.getValue();
        POA namingPOA = (POA)this.namingPOAInjector.getValue();
        try {
            NamingContextImpl.init((ORB)orb, (POA)rootPOA);
            org.jboss.as.jacorb.naming.NamingContextImpl ns = new org.jboss.as.jacorb.naming.NamingContextImpl(namingPOA);
            Configuration config = ((org.jacorb.orb.ORB)orb).getConfiguration();
            ns.configure(config);
            byte[] rootContextId = "root".getBytes();
            namingPOA.activate_object_with_id(rootContextId, (Servant)ns);
            this.namingService = NamingContextExtHelper.narrow((Object)namingPOA.create_reference_with_id(rootContextId, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
        }
        catch (Exception e) {
            throw new StartException("Failed to start the CORBA Naming Service", (Throwable)e);
        }
        CorbaServiceUtil.bindObject(context.getChildTarget(), "corbanaming", this.namingService);
        log.info((java.lang.Object)"CORBA Naming Service Started");
        log.debugf("Naming: [" + orb.object_to_string((Object)this.namingService) + "]", new java.lang.Object[0]);
    }

    public void stop(StopContext context) {
        log.debugf("Stopping Service " + context.getController().getName().getCanonicalName(), new java.lang.Object[0]);
    }

    public NamingContextExt getValue() throws IllegalStateException, IllegalArgumentException {
        return this.namingService;
    }

    public Injector<ORB> getORBInjector() {
        return this.orbInjector;
    }

    public Injector<POA> getRootPOAInjector() {
        return this.rootPOAInjector;
    }

    public Injector<POA> getNamingPOAInjector() {
        return this.namingPOAInjector;
    }
}

