/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.RetryStrategyFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.PortableServer.POA;
import org.picocontainer.defaults.DefaultPicoContainer;

public abstract class AbstractProxyPushSupplier
extends AbstractProxySupplier
implements IProxyPushSupplier {
    private static final String NOTIFY_PUSH_FAILED = "notification.proxy.push_failed";
    private final AtomicReference retryStrategyFactory_;
    private final AtomicBoolean enabled_ = new AtomicBoolean(true);
    private final PushTaskExecutor pushTaskExecutor_;
    private final AtomicInteger pushCounter_ = new AtomicInteger(0);
    private final AtomicInteger pushErrors_ = new AtomicInteger(0);
    protected final Semaphore pushSync_ = new Semaphore(1);
    private final PushTaskExecutor.PushTask pushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            if (AbstractProxyPushSupplier.this.isEnabled()) {
                AbstractProxyPushSupplier.this.tryPushEvent();
            }
        }

        public void cancel() {
        }
    };
    private final PushTaskExecutor.PushTask flushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            if (AbstractProxyPushSupplier.this.isEnabled()) {
                AbstractProxyPushSupplier.this.flushPendingEvents();
            }
        }

        public void cancel() {
        }
    };

    public AbstractProxyPushSupplier(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.pushTaskExecutor_ = pushTaskExecutorFactory.newExecutor(this);
        this.retryStrategyFactory_ = new AtomicReference<RetryStrategyFactory>(this.newRetryStrategyFactory(configuration, taskProcessor));
        this.eventTypes_.add(NOTIFY_PUSH_FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryPushEvent() {
        try {
            boolean bl = this.pushSync_.tryAcquire(1000L, TimeUnit.MILLISECONDS);
            if (!bl) {
                this.schedulePush();
                return true;
            }
            try {
                boolean bl2 = this.pushEvent();
                return bl2;
            }
            finally {
                this.pushSync_.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    protected abstract boolean pushEvent();

    protected void handleFailedPushOperation(PushOperation pushOperation, Exception exception) {
        this.logger_.warn("handle failed pushoperation", (Throwable)exception);
        if (this.isDestroyed()) {
            pushOperation.dispose();
            return;
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        this.sendNotification(NOTIFY_PUSH_FAILED, "Push Operation failed", stringWriter.toString());
        this.pushErrors_.getAndIncrement();
        this.incErrorCounter();
        if (AbstractRetryStrategy.isFatalException(exception)) {
            if (this.logger_.isWarnEnabled()) {
                this.logger_.warn("push raised " + exception + ": will destroy ProxySupplier, " + "disconnect Consumer", (Throwable)exception);
            }
            pushOperation.dispose();
            this.destroy();
        } else if (!this.isRetryAllowed()) {
            this.logger_.warn("no more retries allowed. disconnect consumer");
            pushOperation.dispose();
            this.destroy();
        } else if (!this.isDestroyed()) {
            RetryStrategy retryStrategy = this.newRetryStrategy(this, pushOperation);
            try {
                retryStrategy.retry();
            }
            catch (RetryException retryException) {
                this.logger_.error("retry failed", (Throwable)retryException);
                retryStrategy.dispose();
                this.destroy();
            }
        } else {
            throw new IllegalStateException("should not happen");
        }
    }

    private RetryStrategy newRetryStrategy(IProxyPushSupplier iProxyPushSupplier, PushOperation pushOperation) {
        return ((RetryStrategyFactory)this.retryStrategyFactory_.get()).newRetryStrategy(iProxyPushSupplier, pushOperation);
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration configuration, TaskProcessor taskProcessor) throws ConfigurationException {
        String string = configuration.getAttribute("jacorb.notification.proxysupplier.retrystrategy_factory", Default.DEFAULT_RETRY_STRATEGY_FACTORY);
        try {
            return this.newRetryStrategyFactory(configuration, taskProcessor, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("jacorb.notification.proxysupplier.retrystrategy_factory", classNotFoundException);
        }
    }

    public void setRetryStrategy(String string) throws ClassNotFoundException {
        RetryStrategyFactory retryStrategyFactory = this.newRetryStrategyFactory(this.config_, this.getTaskProcessor(), string);
        this.retryStrategyFactory_.set(retryStrategyFactory);
        this.logger_.info("set RetryStrategyFactory: " + string);
    }

    public String getRetryStrategy() {
        return this.retryStrategyFactory_.get().getClass().getName();
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration configuration, TaskProcessor taskProcessor, String string) throws ClassNotFoundException {
        Class clazz = ObjectUtil.classForName(string);
        DefaultPicoContainer defaultPicoContainer = new DefaultPicoContainer();
        defaultPicoContainer.registerComponentInstance(TaskProcessor.class, (Object)taskProcessor);
        defaultPicoContainer.registerComponentImplementation(RetryStrategyFactory.class, clazz);
        defaultPicoContainer.registerComponentInstance((Object)configuration);
        return (RetryStrategyFactory)defaultPicoContainer.getComponentInstance(RetryStrategyFactory.class);
    }

    public final void schedulePush() {
        if (this.isEnabled()) {
            this.scheduleTask(this.pushTask_);
        }
    }

    public void scheduleFlush() {
        if (this.isEnabled()) {
            this.scheduleTask(this.flushTask_);
        }
    }

    public final void scheduleTask(PushTaskExecutor.PushTask pushTask) {
        if (!this.isDestroyed() && !this.isSuspended()) {
            this.pushTaskExecutor_.executePush(pushTask);
        }
    }

    public void flushPendingEvents() {
        while (this.tryPushEvent()) {
        }
    }

    public final void messageQueued() {
        if (this.isEnabled()) {
            this.schedulePush();
        }
    }

    public void resetErrorCounter() {
        super.resetErrorCounter();
        this.pushCounter_.getAndIncrement();
        this.enableDelivery();
    }

    public void disableDelivery() {
        boolean bl = this.enabled_.getAndSet(false);
        if (bl) {
            this.logger_.warn("disabled delivery to ProxySupplier temporarily");
        }
    }

    protected boolean isEnabled() {
        return this.enabled_.get();
    }

    private void enableDelivery() {
        boolean bl = this.enabled_.getAndSet(true);
        if (!bl) {
            this.logger_.debug("enabled delivery to ProxySupplier");
        }
    }

    public int getPushOperationCount() {
        return this.pushCounter_.get();
    }

    public int getPushErrorCount() {
        return this.pushErrors_.get();
    }

    public int getAveragePushDuration() {
        return (int)this.getCost() / this.getPushOperationCount();
    }
}

